/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.ServerAdapterFactory;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.WtpBridgeExtension;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class WTPServerBridge {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPServerBridge.class);
    private static WTPServerBridge instance = null;
    private Hashtable<String, WtpBridgeExtension> connectionProfileReg = new Hashtable();
    private Hashtable<String, String> connectionCatReg = new Hashtable();
    private Hashtable<String, IConnectionProfile> connectionProfileTab = new Hashtable();

    protected WTPServerBridge() {
        try {
            this.loadConnectionProfileIDFromReg();
        }
        catch (Exception e) {
            LOG.error((Object)"error during create wtp server bridge", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static WTPServerBridge getInstance() {
        if (instance == null) {
            instance = new WTPServerBridge();
        }
        return instance;
    }

    public IConnectionProfile[] getConnectionProfile() {
        return null;
    }

    public IConnectionProfile[] getProfiles() {
        return this.getProfilesByCategory(null);
    }

    public IConnectionProfile[] getProfilesByCategory(String catId) {
        LOG.debug((Object)("wtp bridge get profile by cat called:" + catId));
        ArrayList<IConnectionProfile> profiles = new ArrayList<IConnectionProfile>();
        try {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n = 0;
            int n2 = iServerArray.length;
            while (n < n2) {
                String connectionProfileProvider;
                IServer server = iServerArray[n];
                IServerType type = server.getServerType();
                String connectionCat = this.getConnectionCatByServerType(type.getId());
                if ((catId == null || connectionCat.equals(catId)) && (connectionProfileProvider = this.getConnectionProfileByServerType(type.getId())) != null) {
                    WtpBridgeExtension ext = this.connectionProfileReg.get(type.getId());
                    IConnectionProfile wtpAdapter = ServerAdapterFactory.createWTPServerAdapter(server, connectionProfileProvider, ext);
                    this.connectionProfileTab.put(wtpAdapter.getName(), wtpAdapter);
                    profiles.add(wtpAdapter);
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOG.debug((Object)("profiles from wtp:" + profiles.size()));
        return profiles.toArray(new IConnectionProfile[0]);
    }

    public IConnectionProfile getProfileByName(String name) {
        return this.connectionProfileTab.get(name);
    }

    private String getConnectionProfileByServerType(String typeID) {
        return this.connectionProfileReg.get((Object)typeID).connectionProfileID;
    }

    private String getConnectionCatByServerType(String typeID) {
        return this.connectionCatReg.get(typeID);
    }

    private void loadConnectionProfileIDFromReg() throws CoreException {
        IExtension[] exts;
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.stp.soas.deploy.core.wtpBridge");
        IExtension[] iExtensionArray = exts = exp.getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IConfigurationElement[] cfgs;
            IExtension ext = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = cfgs = ext.getConfigurationElements();
            int n3 = 0;
            int n4 = iConfigurationElementArray.length;
            while (n3 < n4) {
                IConfigurationElement cfg = iConfigurationElementArray[n3];
                if (cfg.getName().equals("serverTypeMap")) {
                    String serverType = cfg.getAttribute("wtpServerType");
                    String cpID = cfg.getAttribute("stpConnectionProfile");
                    System.err.println("cpID:" + cpID);
                    String catID = cfg.getAttribute("stpProfileCatetory");
                    WtpBridgeExtension wtpExt = new WtpBridgeExtension(serverType, cpID, cfg);
                    this.connectionProfileReg.put(serverType, wtpExt);
                    this.connectionCatReg.put(serverType, catID);
                }
                ++n3;
            }
            ++n;
        }
    }
}

