/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.ui.actions.CreatePackageFileAction;
import org.eclipse.stp.soas.internal.deploy.ui.viewers.DropListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CreatePackageControl {
    public static final String LABEL_SERVER_TYPE = DeployCorePlugin.getDefault().getResourceString("LABEL_SERVER_TYPE");
    public static final String BUTTON_CREATE_PACKAGE = DeployCorePlugin.getDefault().getResourceString("BUTTON_CREATE_PACKAGE");
    private Composite mControl;
    private DropListViewer mPackageConstructors;
    private Button mCreatePackageButton;
    private TechnologyTypeFilter mConstructorFilter = new TechnologyTypeFilter(null);
    private ILogicalPackage mPackage;
    private boolean mEnabled = true;

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.mControl = toolkit.createComposite(parent);
        this.mControl.setLayout((Layout)new GridLayout(3, false));
        Label label = toolkit.createLabel(this.mControl, LABEL_SERVER_TYPE);
        label.setLayoutData((Object)new GridData());
        this.mPackageConstructors = new DropListViewer(this.mControl);
        this.mPackageConstructors.setLabelProvider((IBaseLabelProvider)new PackageConstructorLabelProvider());
        this.mPackageConstructors.setContentProvider((IContentProvider)new PackageConstructorContentProvider());
        this.mPackageConstructors.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CreatePackageControl.this.handlePackageConstructorChanged();
            }
        });
        this.mPackageConstructors.addFilter((ViewerFilter)this.mConstructorFilter);
        this.mPackageConstructors.setInput((Object)DeploymentExtensionManager.getInstance());
        this.mCreatePackageButton = toolkit.createButton(this.mControl, BUTTON_CREATE_PACKAGE, 8);
        this.mCreatePackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreatePackageControl.this.createPackage();
            }
        });
    }

    public IPackageConstructorExtension getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.mPackageConstructors.getSelection();
        IPackageConstructorExtension retVal = selection.isEmpty() ? null : (IPackageConstructorExtension)selection.getFirstElement();
        return retVal;
    }

    public void setSelection(IPackageConstructorExtension selection) {
        if (selection == null) {
            this.mPackageConstructors.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.mPackageConstructors.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
    }

    public void setInputFile(IFile file) {
        this.mPackage = DeploymentExtensionManager.getInstance().getLogicalPackage(file);
        this.mConstructorFilter.setPackage(this.mPackage);
        this.mPackageConstructors.refresh();
        if (this.mPackageConstructors.getCombo().getItemCount() > 0) {
            Combo combo = this.mPackageConstructors.getCombo();
            combo.setText(combo.getItem(0));
        }
        this.updateControls();
    }

    public boolean getEnabled() {
        return this.mCreatePackageButton.getEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        this.updateControls();
    }

    public Control getControl() {
        return this.mControl;
    }

    public void createPackage() {
        new CreatePackageFileAction(new String(), this.mPackage, this.getSelection()).run();
    }

    private void handlePackageConstructorChanged() {
        this.updateControls();
    }

    private void updateControls() {
        if (this.mCreatePackageButton == null) {
            return;
        }
        this.mCreatePackageButton.setEnabled(this.mEnabled && !((IStructuredSelection)this.mPackageConstructors.getSelection()).isEmpty());
    }

    public static class PackageConstructorContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            DeploymentExtensionManager dem = (DeploymentExtensionManager)inputElement;
            ArrayList constructors = new ArrayList();
            for (IDeployDriverExtension driver : dem.getDeployDrivers()) {
                constructors.addAll(driver.getPackageConstructors());
            }
            return constructors.toArray();
        }

        public void dispose() {
        }
    }

    public static class PackageConstructorLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            IDeployDriverExtension driver = ((IPackageConstructorExtension)element).getDeployDriver();
            String retVal = driver.getName();
            if (retVal == null) {
                retVal = driver.getID();
                String profileType = driver.getConnectionProfileProvider().getName();
                if (profileType != null && profileType.length() > 0) {
                    retVal = String.valueOf(retVal) + " (" + profileType + ")";
                }
            }
            return retVal;
        }
    }

    public static class TechnologyTypeFilter
    extends ViewerFilter {
        private ILogicalPackage mPackage;

        public TechnologyTypeFilter(ILogicalPackage pkg) {
            this.setPackage(pkg);
        }

        public void setPackage(ILogicalPackage pkg) {
            this.mPackage = pkg;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.mPackage == null || ((IPackageConstructorExtension)element).supportsPackage(this.mPackage);
        }
    }
}

