/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.deploy.tomcat.cp;

import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.soas.deploy.tomcat.DeployTomcatResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TomcatDirWizardPage extends ConnectionProfileDetailsPage {

    
    private static ImageDescriptor defaultImgDesc = 
        DeployTomcatResources.getImageDescriptor("wizban/new_tomcat_cp_wiz.gif");
    
	private Text txtTomcatDir;
	public TomcatDirWizardPage(String name) {
		super(name);
	}
	
	public TomcatDirWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        setTitle(DeployTomcatResources.getString("connection.profile.tomcat.dir.page.title"));
        setDescription(DeployTomcatResources.getString("connection.profile.tomcat.dir.page.desc"));
        setImageDescriptor(defaultImgDesc);
    }

	@Override
	public void createCustomControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout(3, false);
		content.setLayout(layout);

		Label lblDir = new Label(content, SWT.NULL);
		lblDir.setLayoutData(new GridData());
		lblDir.setText(DeployTomcatResources.getString("lbl.tomcat.install.dir"));

		txtTomcatDir = new Text(content, SWT.BORDER);
		txtTomcatDir.setLayoutData(new GridData());
		
		Button btnTomcatDir = new Button(content, SWT.PUSH);
		txtTomcatDir.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnTomcatDir.setText(DeployTomcatResources.getString("button.browse"));
		btnTomcatDir.addSelectionListener(new SelectionAdapter() {
		    public void widgetSelected(SelectionEvent e) {
		    	DirectoryDialog dialog = new DirectoryDialog(getShell(), SWT.OPEN);
		        String dir = dialog.open();
		        if ((dir != null) && (dir.length() > 0)) {
		        	txtTomcatDir.setText(dir);
		        }
		    }
		});
		
	}
	
	public String getTomcatDir() {
		return txtTomcatDir.getText();
	}
	
	public void setTomcatDir(String value) {
		txtTomcatDir.setText(value);
	}

}
