/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtension;

public class OperationExtensionReader
extends RegistryReader {
    protected static HashMap opExtensions = null;
    public static final String ELEMENT_J2EEOPEXT = "operationExtension";
    public static final String ATT_ID = "id";
    public static final String ATT_PRE_OP = "preOperationClass";
    public static final String ATT_POST_OP = "postOperationClass";

    public OperationExtensionReader() {
        super("org.eclipse.wst.common.frameworks", "OperationExtension");
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(ELEMENT_J2EEOPEXT)) {
            return false;
        }
        String id = element.getAttribute(ATT_ID);
        String preOp = element.getAttribute(ATT_PRE_OP);
        String postOp = element.getAttribute(ATT_POST_OP);
        OperationExtension extension = new OperationExtension(element, id, preOp, postOp);
        OperationExtensionReader.addExtensionPoint(extension);
        return true;
    }

    private static void addExtensionPoint(OperationExtension newExtension) {
        ArrayList<OperationExtension> temp = null;
        Object holder = opExtensions.get(newExtension.getOpID());
        if (holder == null) {
            temp = new ArrayList<OperationExtension>();
            temp.add(newExtension);
            opExtensions.put(newExtension.getOpID(), temp);
        } else {
            temp = (ArrayList<OperationExtension>)holder;
            temp.add(newExtension);
        }
    }

    public static HashMap getExtensionPoints() {
        if (opExtensions == null) {
            opExtensions = new HashMap();
            OperationExtensionReader opExtensionReader = new OperationExtensionReader();
            opExtensionReader.readRegistry();
        }
        return opExtensions;
    }
}

