/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMCallbackThread;
import org.eclipse.jem.internal.proxy.remote.REMInterfaceBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMCallbackRegistry
implements ICallbackRegistry {
    final REMProxyFactoryRegistry fFactory;
    final String fNamePostfix;
    List fThreads = Collections.synchronizedList(new LinkedList());
    Map fIdToCallback = new HashMap(5);
    Map fCallbackProxyToId = new HashMap(5);
    IREMMethodProxy fInitializeCallback;
    IBeanProxy fRemoteServer;
    boolean registryOpen = true;

    public REMCallbackRegistry(String name, REMProxyFactoryRegistry aFactory) {
        this.fFactory = aFactory;
        this.fNamePostfix = name;
        REMInterfaceBeanTypeProxy callbackType = new REMInterfaceBeanTypeProxy(this.fFactory, new Integer(30), "org.eclipse.jem.internal.proxy.vm.remote.ICallback");
        this.fInitializeCallback = (IREMMethodProxy)((REMMethodProxyFactory)this.fFactory.getMethodProxyFactory()).methodType.newBeanProxy(new Integer(33));
        this.fRemoteServer = aFactory.getBeanProxyFactory().getIVMServerProxy();
        ((REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory()).registerBeanTypeProxy(callbackType, true);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(this.fInitializeCallback);
    }

    public boolean createCallback(Socket incoming) {
        if (this.registryOpen) {
            REMCallbackThread st = new REMCallbackThread(incoming, this, "Callback Thread-" + this.fNamePostfix, this.fFactory, this.fFactory.fNoTimeouts);
            this.fThreads.add(st);
            st.start();
            return true;
        }
        return false;
    }

    public boolean requestShutdown() {
        if (!this.registryOpen) {
            return false;
        }
        this.shutdown();
        return true;
    }

    public void removeCallbackThread(REMCallbackThread thread) {
        this.fThreads.remove(thread);
    }

    private void shutdown() {
        REMCallbackThread[] threadsArray = this.fThreads.toArray(new REMCallbackThread[this.fThreads.size()]);
        int i = 0;
        while (i < threadsArray.length) {
            threadsArray[i].close();
            ++i;
        }
        i = 0;
        while (i < threadsArray.length) {
            try {
                threadsArray[i].join(10000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        this.fThreads.clear();
        this.fIdToCallback.clear();
        this.fCallbackProxyToId.clear();
        this.fInitializeCallback = null;
        this.fRemoteServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICallback getRegisteredCallback(int id) {
        Map map = this.fIdToCallback;
        synchronized (map) {
            return (ICallback)this.fIdToCallback.get(new Integer(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(IBeanProxy callbackProxy, ICallback cb) {
        Map map = this.fIdToCallback;
        synchronized (map) {
            this.fIdToCallback.put(((IREMBeanProxy)callbackProxy).getID(), cb);
            this.fCallbackProxyToId.put(callbackProxy, ((IREMBeanProxy)callbackProxy).getID());
            this.fInitializeCallback.invokeCatchThrowableExceptions(callbackProxy, new IBeanProxy[]{this.fRemoteServer, this.fFactory.getBeanProxyFactory().createBeanProxyWith((int)((IREMBeanProxy)callbackProxy).getID())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(IProxy callbackProxy, ICallback cb, IExpression expression) {
        Integer id;
        if (callbackProxy.isBeanProxy()) {
            id = ((IREMBeanProxy)callbackProxy).getID();
            Map map = this.fIdToCallback;
            synchronized (map) {
                this.fIdToCallback.put(id, cb);
                this.fCallbackProxyToId.put(callbackProxy, id);
            }
        }
        id = new Integer(callbackProxy.hashCode());
        Map map = this.fIdToCallback;
        synchronized (map) {
            this.fIdToCallback.put(id, cb);
        }
        ((ExpressionProxy)callbackProxy).addProxyListener(new ExpressionProxy.ProxyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                Map map = REMCallbackRegistry.this.fIdToCallback;
                synchronized (map) {
                    REMCallbackRegistry.this.fCallbackProxyToId.put(event.getProxy(), id);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                Map map = REMCallbackRegistry.this.fIdToCallback;
                synchronized (map) {
                    REMCallbackRegistry.this.fIdToCallback.remove(id);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                Map map = REMCallbackRegistry.this.fIdToCallback;
                synchronized (map) {
                    REMCallbackRegistry.this.fIdToCallback.remove(id);
                }
            }
        });
        expression.createSimpleMethodInvoke(this.fInitializeCallback, callbackProxy, new IProxy[]{this.fRemoteServer, this.fFactory.getBeanProxyFactory().createBeanProxyWith((int)id)}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterCallback(IBeanProxy callbackProxy) {
        Map map = this.fIdToCallback;
        synchronized (map) {
            Integer id = (Integer)this.fCallbackProxyToId.remove(callbackProxy);
            this.fIdToCallback.remove(id);
        }
    }
}

