/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class ImageHandlerJPEGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerJPEGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        super(string, string2);
    }

    public final String getSuffix() {
        return ".jpg";
    }

    public final String getPrefix() {
        return "jpegImage";
    }

    public void encodeImage(BufferedImage bufferedImage, File file) throws SVGGraphics2DIOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, false);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("could not write image File " + file.getName());
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 1);
    }
}

