/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.SubPageSite;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MultiPageEditorOutlinePage
extends Page
implements IContentOutlinePage,
SelectionListener {
    private static final Logger log = EditorPlugin.getLogger(MultiPageEditorOutlinePage.class);
    private ListenerList selectionChangedListeners = new ListenerList(1);
    private PageBook pageBook = null;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            MultiPageEditorOutlinePage.this.pageSelectionChanged(event);
        }
    };
    private PageRec defaultPageRec;
    private Map mapPartToRec = new HashMap();
    private Map mapPageToSite = new HashMap();
    private PageRec activeRec;
    private CTabFolder tabFolder;

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        IPage defaultPage = this.createDefaultPage(this.pageBook);
        this.defaultPageRec = new PageRec(null, defaultPage);
        this.preparePage(this.defaultPageRec);
        this.showPageRec(this.defaultPageRec);
        if (this.getContainerForMultiPageEditorPart() != null) {
            this.getContainerForMultiPageEditorPart().addSelectionListener((SelectionListener)this);
        }
        this.showBootstrapPart();
    }

    public void dispose() {
        this.activeRec = null;
        if (this.defaultPageRec != null) {
            this.defaultPageRec.page.dispose();
            this.defaultPageRec = null;
        }
        Map clone = (Map)((HashMap)this.mapPartToRec).clone();
        for (PageRec rec : clone.values()) {
            this.removePage(rec);
        }
        super.dispose();
    }

    protected IPage createDefaultPage(PageBook book) {
        String defaultText = EditorMessages.MultiPageEditorOutlinePage_noOutline;
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(defaultText);
        return page;
    }

    private void preparePage(PageRec rec) {
        IPageSite site = null;
        if (!this.doesPageExist(rec.page)) {
            if (rec.page instanceof IPageBookViewPage) {
                site = ((IPageBookViewPage)rec.page).getSite();
            }
            if (site == null) {
                site = new SubPageSite(this.getSite());
            }
            this.mapPageToSite.put(rec.page, site);
            rec.subActionBars = (SubActionBars)site.getActionBars();
            rec.page.setActionBars((IActionBars)rec.subActionBars);
        } else {
            site = (IPageSite)this.mapPageToSite.get(rec.page);
            rec.subActionBars = (SubActionBars)site.getActionBars();
        }
    }

    public IPage getCurrentPage() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.page;
    }

    protected SubPageSite getPageSite(IPage page) {
        return (SubPageSite)this.mapPageToSite.get(page);
    }

    protected void showPageRec(PageRec pageRec) {
        SubPageSite pageSite = this.getPageSite(pageRec.page);
        ISelectionProvider provider = pageSite.getSelectionProvider();
        if (provider == null && pageRec.page instanceof IContentOutlinePage) {
            pageSite.setSelectionProvider((ISelectionProvider)((IContentOutlinePage)pageRec.page));
        }
        if (this.activeRec == pageRec) {
            return;
        }
        if (this.activeRec != null && pageRec != null && this.activeRec.page == pageRec.page) {
            this.activeRec = pageRec;
            return;
        }
        if (this.activeRec != null) {
            this.activeRec.subActionBars.deactivate();
            provider = ((SubPageSite)this.mapPageToSite.get(this.activeRec.page)).getSelectionProvider();
            if (provider != null) {
                provider.removeSelectionChangedListener(this.selectionChangedListener);
            }
        }
        this.activeRec = pageRec;
        Control pageControl = this.activeRec.page.getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.pageBook.showPage(pageControl);
            this.activeRec.subActionBars.activate();
            this.refreshGlobalActionHandlers();
            provider = ((SubPageSite)this.mapPageToSite.get(this.activeRec.page)).getSelectionProvider();
            if (provider != null) {
                provider.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.getSite().getActionBars().updateActionBars();
        }
    }

    private void refreshGlobalActionHandlers() {
        IActionBars bars = this.getSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Map newActionHandlers = this.activeRec.subActionBars.getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            for (Map.Entry entry : keys) {
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    private PageRec createPage(IWorkbenchPart part) {
        PageRec rec = this.doCreatePage(part);
        if (rec != null) {
            this.mapPartToRec.put(part, rec);
            this.preparePage(rec);
        }
        return rec;
    }

    protected PageRec doCreatePage(IWorkbenchPart part) {
        Object obj = part.getAdapter(IContentOutlinePage.class);
        if (obj instanceof IContentOutlinePage) {
            IContentOutlinePage page = (IContentOutlinePage)obj;
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            return new PageRec(part, (IPage)page);
        }
        return null;
    }

    protected PageBook getPageBook() {
        return this.pageBook;
    }

    protected PageRec getPageRec(Object part) {
        return (PageRec)this.mapPartToRec.get(part);
    }

    protected void initPage(IPageBookViewPage page) {
        try {
            page.init((IPageSite)new SubPageSite(this.getSite()));
        }
        catch (PartInitException e) {
            log.error(e.getMessage());
        }
    }

    private void showBootstrapPart() {
        IWorkbenchPart part = this.getBootstrapPart();
        if (part != null) {
            this.partActivated(part);
        }
    }

    private IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null && page.getActiveEditor() instanceof MultiPageEditorPart) {
            return (IWorkbenchPart)page.getActiveEditor().getAdapter(IEditorPart.class);
        }
        return null;
    }

    private void partActivated(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return;
        }
        PageRec rec = this.getPageRec(part);
        if (rec == null) {
            rec = this.createPage(part);
        }
        if (rec != null) {
            this.showPageRec(rec);
        } else {
            this.showPageRec(this.defaultPageRec);
        }
    }

    private boolean doesPageExist(IPage page) {
        return this.mapPageToSite.containsKey(page);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    private CTabFolder getContainerForMultiPageEditorPart() {
        if (this.tabFolder == null) {
            this.tabFolder = (CTabFolder)this.getSite().getPage().getActiveEditor().getAdapter(CTabFolder.class);
        }
        return this.tabFolder;
    }

    private void removePage(PageRec rec) {
        Control control;
        this.mapPartToRec.remove(rec.part);
        IPageSite site = (IPageSite)this.mapPageToSite.remove(rec.page);
        if (rec.subActionBars != null) {
            rec.subActionBars.dispose();
        }
        if ((control = rec.page.getControl()) != null && !control.isDisposed()) {
            control.dispose();
        }
        if (site instanceof SubPageSite) {
            ((SubPageSite)site).dispose();
        }
        this.doDestroyPage(rec.part, rec);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageRec rec) {
        IContentOutlinePage page = (IContentOutlinePage)rec.page;
        page.dispose();
        rec.dispose();
    }

    public Control getControl() {
        return this.pageBook;
    }

    public void setFocus() {
        if (this.getControl() != null) {
            this.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        IPage currentPage = this.getCurrentPage();
        if (currentPage == null) {
            return StructuredSelection.EMPTY;
        }
        SubPageSite site = this.getPageSite(currentPage);
        if (site == null) {
            return StructuredSelection.EMPTY;
        }
        ISelectionProvider selProvider = site.getSelectionProvider();
        if (selProvider != null) {
            return selProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        IPage currentPage = this.getCurrentPage();
        if (currentPage == null) {
            return;
        }
        SubPageSite site = this.getPageSite(currentPage);
        if (site == null) {
            return;
        }
        ISelectionProvider selProvider = site.getSelectionProvider();
        if (selProvider != null) {
            selProvider.setSelection(selection);
        }
    }

    public void pageSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        EditorPart part = (EditorPart)((CTabItem)e.item).getData();
        if (part != null) {
            this.partActivated((IWorkbenchPart)part);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected static class PageRec {
        public IWorkbenchPart part;
        public IPage page;
        public SubActionBars subActionBars;

        public PageRec(IWorkbenchPart part, IPage page) {
            this.part = part;
            this.page = page;
        }

        public void dispose() {
            this.part = null;
            this.page = null;
        }
    }
}

