/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.operations.jsf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PanelGridOperation
extends AbstractTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        Element footerFacetElement;
        Element headerFacetElement;
        int columns;
        Element tableElement = null;
        tableElement = this.createElement("table");
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation("CopyAllAttributesOperation", new String[0]);
        operation.transform(srcElement, tableElement);
        operation = TransformOperationFactory.getInstance().getTransformOperation("RenameAttributeOperation", new String[]{"styleClass", "class"});
        operation.transform(srcElement, tableElement);
        try {
            columns = Integer.parseInt(srcElement.getAttribute("columns"));
        }
        catch (NumberFormatException numberFormatException) {
            columns = 1;
        }
        if (columns < 1) {
            columns = 1;
        }
        if ((headerFacetElement = this.getChildFacetByName(srcElement, "header")) != null) {
            Element tHeadElement = this.appendChildElement("thead", tableElement);
            Element trElement = this.appendChildElement("tr", tHeadElement);
            Element thElement = this.appendChildElement("th", trElement);
            String headerClass = srcElement.getAttribute("headerClass");
            if (headerClass != null && headerClass.length() > 0) {
                operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", headerClass});
                operation.transform(srcElement, thElement);
            }
            operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"colspan", String.valueOf(columns)});
            operation.transform(srcElement, thElement);
            this.tagConverterContext.addChild((Node)headerFacetElement, new ConvertPosition((Node)thElement, 0));
        }
        if ((footerFacetElement = this.getChildFacetByName(srcElement, "footer")) != null) {
            Element tFootElement = this.appendChildElement("tfoot", tableElement);
            Element trElement = this.appendChildElement("tr", tFootElement);
            Element tdElement = this.appendChildElement("td", trElement);
            String footerClass = srcElement.getAttribute("footerClass");
            if (footerClass != null && footerClass.length() > 0) {
                operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", footerClass});
                operation.transform(srcElement, tdElement);
            }
            operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"colspan", String.valueOf(columns)});
            operation.transform(srcElement, tdElement);
            this.tagConverterContext.addChild((Node)footerFacetElement, new ConvertPosition((Node)tdElement, 0));
        }
        ArrayList<String> rowClasses = new ArrayList<String>();
        String rowClassesAttribute = srcElement.getAttribute("rowClasses");
        if (rowClassesAttribute != null && rowClassesAttribute.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(rowClassesAttribute, ", ");
            while (tokenizer.hasMoreTokens()) {
                rowClasses.add(tokenizer.nextToken());
            }
        }
        ArrayList<String> columnClasses = new ArrayList<String>();
        String columnClassAttribute = srcElement.getAttribute("columnClasses");
        if (columnClassAttribute != null) {
            StringTokenizer tokenizer = new StringTokenizer(columnClassAttribute, ", ");
            while (tokenizer.hasMoreTokens()) {
                columnClasses.add(tokenizer.nextToken());
            }
        }
        Element tBodyElement = this.appendChildElement("tbody", tableElement);
        List childElements = this.getChildElementsSkipFacets(srcElement);
        Element trElement = null;
        int nextRow = 0;
        int curIndex = 0;
        Iterator itChildElements = childElements.iterator();
        while (itChildElements.hasNext()) {
            int columnIndex = curIndex % columns;
            if (columnIndex == 0) {
                trElement = this.appendChildElement("tr", tBodyElement);
                if (!rowClasses.isEmpty()) {
                    operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", (String)rowClasses.get(nextRow)});
                    operation.transform(srcElement, trElement);
                    nextRow = (nextRow + 1) % rowClasses.size();
                }
            }
            Element tdElement = this.appendChildElement("td", trElement);
            if (columnIndex < columnClasses.size()) {
                operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", (String)columnClasses.get(columnIndex)});
                operation.transform(srcElement, tdElement);
            }
            this.tagConverterContext.addChild((Node)((Element)itChildElements.next()), new ConvertPosition((Node)tdElement, 0));
            ++curIndex;
        }
        return tableElement;
    }

    private Element getChildFacetByName(Element srcElement, String facetName) {
        Element element = null;
        List facets = this.getChildElements(srcElement, "facet");
        for (Element facet : facets) {
            String facetAttrName = facet.getAttribute("name");
            if (facetAttrName == null || !facetAttrName.equals(facetName)) continue;
            element = facet;
            break;
        }
        return element;
    }

    private List getChildElementsSkipFacets(Element srcElement) {
        ArrayList<Node> childElementsList = new ArrayList<Node>();
        NodeList childNodes = srcElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1 && !childNode.getLocalName().equals("facet")) {
                childElementsList.add(childNode);
            }
            ++i;
        }
        return childElementsList;
    }
}

