/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.elementedit.jsfcore;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jst.jsf.core.internal.tld.LoadBundleUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.JSFUIPlugin;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.jsfcore.JarEntryEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class LoadBundleAction
extends Action {
    private String _baseName;
    private IProject _project;

    public LoadBundleAction() {
        this.setText(JSFUIPlugin.getResourceString("ElementEdit.Submenu.LoadBundle"));
    }

    public void setBaseName(String attribute) {
        this._baseName = attribute;
    }

    public void run() {
        if (this._project == null || this._baseName == null) {
            return;
        }
        IStorage storage = null;
        try {
            storage = LoadBundleUtil.getLoadBundleResource((IProject)this._project, (String)this._baseName);
        }
        catch (CoreException e) {
            JSFUIPlugin.getAlerts().warning("Message.Warning.Title", e.getLocalizedMessage());
            return;
        }
        if (storage instanceof IFile) {
            try {
                IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)((IFile)storage), (boolean)true);
            }
            catch (PartInitException e1) {
                JSFUIPlugin.getAlerts().warning("Message.Warning.Title", e1.getLocalizedMessage());
            }
        } else {
            JarEntryEditorInput input = new JarEntryEditorInput(storage);
            try {
                this.getPage().openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
            }
            catch (PartInitException e1) {
                JSFUIPlugin.getAlerts().warning("Message.Warning.Title", e1.getLocalizedMessage());
            }
        }
    }

    private IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public void setProject(IProject projectFor) {
        this._project = projectFor;
    }

    public String getEditorID(String inputName) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = registry.getDefaultEditor(inputName);
        if (editorDescriptor == null && registry.isSystemInPlaceEditorAvailable(inputName)) {
            editorDescriptor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDescriptor == null && registry.isSystemExternalEditorAvailable(inputName)) {
            editorDescriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDescriptor == null) {
            editorDescriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDescriptor == null) {
            return null;
        }
        return editorDescriptor.getId();
    }

    public boolean isEnabled() {
        return this._project != null && this._baseName != null && !"".equals(this._baseName);
    }
}

