/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.internal.IMetaDataEnabledFeatureExtension;
import org.osgi.framework.Bundle;

public final class MetaDataEnabledFeatureAdapterFactory {
    private static MetaDataEnabledFeatureAdapterFactory INSTANCE;

    public static MetaDataEnabledFeatureAdapterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataEnabledFeatureAdapterFactory();
        }
        return INSTANCE;
    }

    private MetaDataEnabledFeatureAdapterFactory() {
    }

    public IMetaDataEnabledFeature getFeatureAdapter(IMetaDataEnabledFeatureExtension feature, Class processingFeature) {
        if (feature != null) {
            return this.createFeature(feature, processingFeature);
        }
        return null;
    }

    private IMetaDataEnabledFeature createFeature(IMetaDataEnabledFeatureExtension featureExt, Class processingFeature) {
        Bundle bundle;
        String className;
        block9: {
            className = featureExt.getClassName();
            bundle = Platform.getBundle((String)featureExt.getBundleID());
            if (bundle != null) break block9;
            JSFCorePlugin.log(4, String.valueOf(featureExt.getBundleID()) + " could not be created to load " + className);
            return null;
        }
        try {
            Class klass = bundle.loadClass(className);
            if (klass != null) {
                if (!IMetaDataEnabledFeature.class.isAssignableFrom(klass)) {
                    JSFCorePlugin.log(1, String.valueOf(className) + " is not a IMetaDataEnabledFeature. " + featureExt.getBundleID() + " : " + featureExt.getTypeID());
                } else if (processingFeature.isAssignableFrom(klass)) {
                    IMetaDataEnabledFeature obj = (IMetaDataEnabledFeature)klass.newInstance();
                    return obj;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            JSFCorePlugin.log(4, String.valueOf(className) + " was not found in " + featureExt.getBundleID() + " for " + featureExt.getTypeID());
        }
        catch (InstantiationException instantiationException) {
            JSFCorePlugin.log(4, "InstantiationException: " + className + " in " + featureExt.getBundleID() + " for " + featureExt.getTypeID());
        }
        catch (IllegalAccessException illegalAccessException) {
            JSFCorePlugin.log(4, "IllegalAccessException: " + className + " in " + featureExt.getBundleID() + " for " + featureExt.getTypeID());
        }
        return null;
    }
}

