/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.internal.MetaDataEnabledFeatureExtension;

public class MetaDataEnabledFeatureRegistry {
    private static final String EXTPTID = "MetaDataEnabledFeatures";
    private Map featuresMap;
    private List EMPTY_LIST = new ArrayList(0);
    private static MetaDataEnabledFeatureRegistry INSTANCE;

    public static synchronized MetaDataEnabledFeatureRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataEnabledFeatureRegistry();
        }
        return INSTANCE;
    }

    private MetaDataEnabledFeatureRegistry() {
        this.featuresMap = new HashMap();
        this.readRegistry();
    }

    protected void readRegistry() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.jsf.core", EXTPTID);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    String bundleId = ext.getConfigurationElements()[j].getContributor().getName();
                    String id = ext.getConfigurationElements()[j].getAttribute("typeid");
                    String klass = ext.getConfigurationElements()[j].getAttribute("class");
                    this.registerFeature(bundleId, id, klass);
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Unable to read org.eclipse.jst.jsf.coreMetaDataEnabledFeatures registry");
        }
    }

    protected void registerFeature(String bundleID, String typeId, String klass) {
        MetaDataEnabledFeatureExtension aFeature = new MetaDataEnabledFeatureExtension(bundleID, typeId, klass);
        if (!this.featuresMap.containsKey(typeId)) {
            ArrayList<MetaDataEnabledFeatureExtension> list = new ArrayList<MetaDataEnabledFeatureExtension>();
            list.add(aFeature);
            this.featuresMap.put(typeId, list);
        } else {
            List list = (List)this.featuresMap.get(typeId);
            list.add(aFeature);
        }
    }

    public List getFeatures(String typeId) {
        if (this.featuresMap.containsKey(typeId)) {
            return (List)this.featuresMap.get(typeId);
        }
        return this.EMPTY_LIST;
    }
}

