/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.IXmlEObject;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.core.internal.JpaEObject;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlEObject
extends JpaEObject
implements IXmlEObject {
    protected IDOMNode node;
    private static final Map<Class, Set<Integer>> insignificantXmlFeatureIdSets = new Hashtable<Class, Set<Integer>>();

    protected XmlEObject() {
    }

    @Override
    protected EClass eStaticClass() {
        return JpaCorePackage.Literals.XML_EOBJECT;
    }

    @Override
    public IJpaFile getJpaFile() {
        IJpaRootContentNode root = this.getRoot();
        return root == null ? null : root.getJpaFile();
    }

    public EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new XmlEAdapterList((Notifier)this);
        }
        return this.eAdapters;
    }

    public IDOMNode getNode() {
        return this.node;
    }

    @Override
    public boolean isAllFeaturesUnset() {
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (this.xmlFeatureIsInsignificant(feature.getFeatureID())) continue;
            if (feature instanceof EReference) {
                Object object = this.eGet(feature);
                if (object instanceof Collection) {
                    if (!this.eIsSet(feature)) continue;
                    return false;
                }
                XmlEObject eObject = (XmlEObject)this.eGet(feature);
                if (eObject == null) continue;
                return eObject.isAllFeaturesUnset();
            }
            if (!this.eIsSet(feature)) continue;
            return false;
        }
        return true;
    }

    public IJpaRootContentNode getRoot() {
        XmlEObject container = (XmlEObject)this.eContainer();
        return container == null ? null : container.getRoot();
    }

    @Override
    public IResource getResource() {
        return this.getJpaFile().getResource();
    }

    @Override
    public ITextRange validationTextRange() {
        return this.fullTextRange();
    }

    public ITextRange selectionTextRange() {
        return this.fullTextRange();
    }

    public ITextRange fullTextRange() {
        return this.buildTextRange(this.node);
    }

    protected ITextRange buildTextRange(IDOMNode domNode) {
        if (domNode == null) {
            return null;
        }
        return new DOMNodeTextRange(domNode);
    }

    protected boolean xmlFeatureIsSignificant(int featureId) {
        return !this.xmlFeatureIsInsignificant(featureId);
    }

    protected boolean xmlFeatureIsInsignificant(int featureId) {
        return this.insignificantXmlFeatureIds().contains(featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> insignificantXmlFeatureIds() {
        Map<Class, Set<Integer>> map = insignificantXmlFeatureIdSets;
        synchronized (map) {
            Set<Integer> insignificantXmlFeatureIds = insignificantXmlFeatureIdSets.get(this.getClass());
            if (insignificantXmlFeatureIds == null) {
                insignificantXmlFeatureIds = new HashSet<Integer>();
                this.addInsignificantXmlFeatureIdsTo(insignificantXmlFeatureIds);
                insignificantXmlFeatureIdSets.put(this.getClass(), insignificantXmlFeatureIds);
            }
            return insignificantXmlFeatureIds;
        }
    }

    protected void addInsignificantXmlFeatureIdsTo(Set<Integer> insignificantXmlFeatureIds) {
    }

    private static class DOMNodeTextRange
    implements ITextRange {
        private final IDOMNode node;

        DOMNodeTextRange(IDOMNode node) {
            this.node = node;
        }

        public int getOffset() {
            return this.node.getStartOffset();
        }

        public int getLength() {
            if (this.node.getNodeType() == 1) {
                return ((IDOMElement)this.node).getStartEndOffset() - this.node.getStartOffset();
            }
            return this.node.getLength();
        }

        public int getLineNumber() {
            return this.node.getStructuredDocument().getLineOfOffset(this.getOffset()) + 1;
        }

        public boolean includes(int index) {
            return this.getOffset() <= index && index < this.end();
        }

        public boolean touches(int index) {
            return this.includes(index) || index == this.end();
        }

        private int end() {
            return this.getOffset() + this.getLength();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ITextRange)) {
                return false;
            }
            ITextRange r = (ITextRange)o;
            return r.getOffset() == this.getOffset() && r.getLength() == this.getLength();
        }

        public int hashCode() {
            return this.getOffset() ^ this.getLength();
        }

        public String toString() {
            String start = String.valueOf(this.getOffset());
            String end = String.valueOf(this.getOffset() + this.getLength() - 1);
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(start) + ", " + end));
        }
    }

    protected class XmlEAdapterList
    extends BasicNotifierImpl.EAdapterList {
        public XmlEAdapterList(Notifier notifier) {
            super(notifier);
        }

        protected void didAdd(int index, Object newObject) {
            super.didAdd(index, newObject);
            try {
                XmlEObject.this.node = (IDOMNode)ClassTools.executeMethod((Object)newObject, (String)"getNode");
            }
            catch (RuntimeException runtimeException) {}
        }

        protected void didRemove(int index, Object oldObject) {
            super.didRemove(index, oldObject);
            if (oldObject instanceof EMF2DOMAdapter && ((EMF2DOMAdapter)oldObject).getNode() == XmlEObject.this.node) {
                XmlEObject.this.node = null;
            }
        }
    }
}

