/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;
import org.eclipse.wst.common.project.facet.ui.internal.ModifyFacetedProjectDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetsSelectionPage
extends WizardPage {
    private static final String IMG_PATH_WIZBAN = "images/facets-page-wizban.png";
    private IWizardContext context;
    private Set<IProjectFacetVersion> base;
    private IPreset initialPreset;
    private Set<IProjectFacetVersion> initialSelection;
    private final Set<IProjectFacet> fixed;
    public FacetsSelectionPanel panel;
    private List<Listener> listeners;
    private List<Combo> initialSyncWithPresetsCombos;
    private IRuntime initialSetDefaultFacetsForRuntime;
    private ModifyFacetedProjectDataModel model;

    public FacetsSelectionPage(IWizardContext context, Set<IProjectFacetVersion> base, ModifyFacetedProjectDataModel model) {
        super("facets.selection.page");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.setImageDescriptor(FacetUiPlugin.getImageDescriptor(IMG_PATH_WIZBAN));
        this.context = context;
        this.base = base;
        this.model = model;
        this.initialPreset = null;
        this.initialSelection = null;
        this.fixed = new HashSet<IProjectFacet>();
        this.listeners = new ArrayList<Listener>();
        this.initialSyncWithPresetsCombos = new ArrayList<Combo>();
        this.initialSetDefaultFacetsForRuntime = null;
    }

    public void setInitialPreset(IPreset preset) {
        this.initialPreset = preset;
    }

    public void setInitialSelection(Set<IProjectFacetVersion> sel) {
        this.initialSelection = sel;
    }

    public void setFixedProjectFacets(Set<IProjectFacet> fixed) {
        this.fixed.clear();
        this.fixed.addAll(fixed);
    }

    public Set<IFacetedProject.Action> getActions() {
        return this.panel.getActions();
    }

    public Set<IProjectFacetVersion> getSelectedProjectFacets() {
        return this.panel.getSelectedProjectFacets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedFacetsChangedListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedFacetsChangedListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void setDefaultFacetsForRuntime(IRuntime runtime) {
        if (this.panel == null) {
            this.initialSetDefaultFacetsForRuntime = runtime;
        } else {
            this.panel.setDefaultFacetsForRuntime(runtime);
        }
    }

    public void syncWithPresetsModel(Combo combo) {
        if (this.initialSyncWithPresetsCombos == null) {
            this.panel.syncWithPresetsModel(combo);
        } else {
            this.initialSyncWithPresetsCombos.add(combo);
        }
    }

    public void createControl(Composite parent) {
        this.panel = new FacetsSelectionPanel(parent, 0, this.context, this.base, this.model);
        this.panel.setFixedProjectFacets(this.fixed);
        if (this.initialPreset != null) {
            this.panel.getDataModel().setSelectedPreset(this.initialPreset.getId());
        }
        if (this.initialSelection != null) {
            this.panel.setSelectedProjectFacets(this.initialSelection);
        }
        if (this.initialSetDefaultFacetsForRuntime != null) {
            this.panel.setDefaultFacetsForRuntime(this.initialSetDefaultFacetsForRuntime);
        }
        this.setPageComplete(this.panel.isSelectionValid());
        this.panel.addProjectFacetsListener(new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPage.this.handleSelectedFacetsChangedEvent(event);
            }
        });
        for (Combo combo : this.initialSyncWithPresetsCombos) {
            this.panel.syncWithPresetsModel(combo);
        }
        this.initialSyncWithPresetsCombos = null;
        IWorkbenchHelpSystem h = PlatformUI.getWorkbench().getHelpSystem();
        h.setHelp((Control)this.panel, "org.eclipse.wst.common.project.facet.ui.facetsSelectionPage");
        this.setControl((Control)this.panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectedFacetsChangedEvent(Event event) {
        this.setPageComplete(this.panel.isSelectionValid());
        ArrayList<Listener> copyOfListenersList = new ArrayList<Listener>();
        List<Listener> list = this.listeners;
        synchronized (list) {
            copyOfListenersList.addAll(this.listeners);
        }
        for (Listener listener : copyOfListenersList) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            for (IFacetedProject.Action action : this.panel.getActions()) {
                Object config = action.getConfig();
                if (config == null) continue;
                IActionConfig c = null;
                if (config instanceof IActionConfig) {
                    c = (IActionConfig)config;
                } else {
                    IAdapterManager m = Platform.getAdapterManager();
                    String t = IActionConfig.class.getName();
                    c = (IActionConfig)m.loadAdapter(config, t);
                }
                if (c == null) continue;
                c.setProjectName(this.context.getProjectName());
            }
        }
        super.setVisible(visible);
        if (visible) {
            this.panel.setFocus();
        }
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;

        static {
            Resources.initializeMessages((String)FacetsSelectionPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

