/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.navigator.internal.EMFModelManager;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class FlexibleEMFModelManager
extends EMFModelManager
implements EditModelListener {
    private List rootObjects = new ArrayList();
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private final List artifactEdits = new ArrayList();
    private final Map artifactEditToRootObject = new HashMap();

    public FlexibleEMFModelManager(IProject aProject, EMFRootObjectProvider provider) {
        super(aProject, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getModels() {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible()) {
                return EMPTY_OBJECT;
            }
            List list = this.rootObjects;
            synchronized (list) {
                if (!this.isValid(this.rootObjects)) {
                    this.rootObjects = this.getRootObjects();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.rootObjects != null) {
            return this.rootObjects.toArray();
        }
        return EMPTY_OBJECT;
    }

    private boolean isValid(List rootObjects) {
        if (rootObjects == null || rootObjects.size() == 0) {
            return false;
        }
        int x = 0;
        while (x < rootObjects.size()) {
            EObject eObject = (EObject)rootObjects.get(x);
            if (eObject != null && eObject.eResource() == null) {
                return false;
            }
            ++x;
        }
        return true;
    }

    private List getRootObjects() {
        List artifacts = this.getArtifactEdits();
        ArrayList<EObject> flexibleObjects = new ArrayList<EObject>();
        ArtifactEdit artifactEdit = null;
        EObject contentModelRoot = null;
        int x = 0;
        while (x < artifacts.size()) {
            artifactEdit = (ArtifactEdit)artifacts.get(x);
            contentModelRoot = artifactEdit.getContentModelRoot();
            if (contentModelRoot != null) {
                flexibleObjects.add(contentModelRoot);
                if (!this.rootObjects.contains(contentModelRoot)) {
                    this.rootObjects.add(contentModelRoot);
                }
                this.artifactEditToRootObject.put(artifactEdit, contentModelRoot);
            }
            ++x;
        }
        return flexibleObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getArtifactEdits() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        List list = this.artifactEdits;
        synchronized (list) {
            if (this.artifactEdits.size() == 0 && project.isAccessible()) {
                ArtifactEdit artifactEdit = null;
                try {
                    artifactEdit = ArtifactEdit.getArtifactEditForRead((IProject)project);
                    if (artifactEdit != null) {
                        this.artifactEdits.add(artifactEdit);
                        artifactEdit.addListener((EditModelListener)this);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.artifactEdits;
    }

    public void dispose() {
        if (this.artifactEdits != null) {
            int x = 0;
            while (x < this.artifactEdits.size()) {
                ArtifactEdit artifactEdit = (ArtifactEdit)this.artifactEdits.get(x);
                if (artifactEdit != null) {
                    artifactEdit.removeListener((EditModelListener)this);
                    artifactEdit.dispose();
                }
                ++x;
            }
        }
        this.rootObjects.clear();
    }

    public void editModelChanged(EditModelEvent anEvent) {
        IProject affectedProject = anEvent.getEditModel().getProject();
        switch (anEvent.getEventCode()) {
            case 3: 
            case 7: {
                Object oldRootObject = this.removeRootObject(anEvent.getEditModel(), affectedProject);
                this.getRootObjects();
                if (oldRootObject == null) break;
                this.notifyListeners(affectedProject);
                break;
            }
            case 1: {
                Object oldRootObject = this.getRootObject(anEvent.getEditModel(), affectedProject);
                if (oldRootObject != null) break;
                this.notifyListeners(affectedProject);
                break;
            }
            case 5: {
                this.dispose(anEvent.getEditModel(), affectedProject);
                break;
            }
        }
    }

    private Object getRootObject(EditModel editModel, IProject project) {
        ArtifactEdit artifactEdit = this.getArtifactEdit(editModel, project);
        if (artifactEdit != null) {
            return this.artifactEditToRootObject.get(artifactEdit);
        }
        return null;
    }

    private Object removeRootObject(EditModel editModel, IProject project) {
        ArtifactEdit artifactEdit = this.getArtifactEdit(editModel, project);
        if (artifactEdit != null) {
            this.rootObjects.remove(this.artifactEditToRootObject.get(artifactEdit));
            this.artifactEditToRootObject.remove(artifactEdit);
        }
        return artifactEdit;
    }

    private void dispose(EditModel editModel, IProject project) {
        ArtifactEdit artifactEdit = this.getArtifactEdit(editModel, project);
        if (artifactEdit != null) {
            artifactEdit.removeListener((EditModelListener)this);
            this.artifactEdits.remove(artifactEdit);
            this.artifactEditToRootObject.remove(artifactEdit);
        }
    }

    private ArtifactEdit getArtifactEdit(EditModel editModel, IProject project) {
        if (this.artifactEdits != null) {
            int x = 0;
            while (x < this.artifactEdits.size()) {
                ArtifactEdit artifactEdit = (ArtifactEdit)this.artifactEdits.get(x);
                if (artifactEdit.hasEditModel(editModel)) {
                    return artifactEdit;
                }
                ++x;
            }
        }
        return null;
    }
}

