/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.internal.cst.ClassifierContextDeclCS;
import org.eclipse.ocl.internal.cst.InvCS;
import org.eclipse.ocl.internal.cst.OCLExpressionCS;
import org.eclipse.ocl.internal.cst.PackageDeclarationCS;
import org.eclipse.ocl.internal.helper.ChoiceImpl;
import org.eclipse.ocl.internal.parser.OCLLexer;
import org.eclipse.ocl.internal.parser.OCLParser;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.util.UnicodeSupport;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OCLSyntaxHelper<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static final int NONE = -1;
    private static final int DOT = 0;
    private static final int ARROW = 1;
    private static final int DOUBLE_COLON = 2;
    private static final int CARET = 3;
    private static final int OCL_IS_IN_STATE = 4;
    private static final Set<String> INFIX_OPERATORS = new HashSet<String>();
    private static final Set<String> ANY_TYPE_OPERATIONS;
    private int syntaxHelpStringSuffix;
    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment;
    private OCLStandardLibrary<C> stdlib;
    private UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml;

    static {
        INFIX_OPERATORS.add("-");
        INFIX_OPERATORS.add("+");
        INFIX_OPERATORS.add("/");
        INFIX_OPERATORS.add("*");
        INFIX_OPERATORS.add("<");
        INFIX_OPERATORS.add("<=");
        INFIX_OPERATORS.add(">");
        INFIX_OPERATORS.add(">=");
        INFIX_OPERATORS.add("=");
        INFIX_OPERATORS.add("<>");
        ANY_TYPE_OPERATIONS = new HashSet<String>();
        ANY_TYPE_OPERATIONS.add("=");
        ANY_TYPE_OPERATIONS.add("<>");
        ANY_TYPE_OPERATIONS.add("oclAsType");
        ANY_TYPE_OPERATIONS.add("oclIsKindOf");
        ANY_TYPE_OPERATIONS.add("oclIsTypeOf");
        ANY_TYPE_OPERATIONS.add("oclIsUndefined");
        ANY_TYPE_OPERATIONS.add("oclIsInvalid");
        ANY_TYPE_OPERATIONS.add("oclIsNew");
        ANY_TYPE_OPERATIONS.add("oclIsInState");
        ANY_TYPE_OPERATIONS.add("<");
        ANY_TYPE_OPERATIONS.add(">");
        ANY_TYPE_OPERATIONS.add("<=");
        ANY_TYPE_OPERATIONS.add(">=");
    }

    OCLSyntaxHelper(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        this.environment = env;
        this.stdlib = env.getOCLStandardLibrary();
        this.uml = env.getUMLReflection();
    }

    private List<Choice> getCollectionChoices(C ct) {
        ArrayList<Choice> result = new ArrayList<Choice>();
        result.addAll(this.getOperationChoices(ct));
        return result;
    }

    private List<Choice> getAnyChoices() {
        return this.getOperationChoices(this.stdlib.getOclAny());
    }

    private List<Choice> getOperationChoices(C owner) {
        List<Choice> result = this.getOperationChoices(owner, TypeUtil.getOperations(this.environment, owner));
        if (owner instanceof CollectionType) {
            CollectionType collType = (CollectionType)owner;
            result.addAll(this.getOperationChoices(owner, (List)collType.oclIterators()));
        }
        return result;
    }

    private List<Choice> getOperationChoices(C owner, List<O> operations) {
        ArrayList<Choice> result = new ArrayList<Choice>(operations.size());
        for (O operation : operations) {
            if (this.syntaxHelpStringSuffix != 3 && !this.isQuery(operation)) continue;
            operation = TypeUtil.resolveGenericSignature(this.environment, owner, operation);
            ChoiceImpl choice = new ChoiceImpl(this.uml.getName(operation), this.getOperationDescription(operation), ChoiceKind.OPERATION, operation);
            result.add(choice);
        }
        return result;
    }

    private List<Choice> getReceptionChoices(C owner) {
        List<C> signals = this.uml.getSignals(owner);
        ArrayList<Choice> result = new ArrayList<Choice>(signals.size());
        for (C signal : signals) {
            ChoiceImpl choice = new ChoiceImpl(this.uml.getName(signal), this.getSignalDescription(signal), ChoiceKind.SIGNAL, signal);
            result.add(choice);
        }
        return result;
    }

    private boolean isQuery(O operation) {
        return this.uml.isQuery(operation);
    }

    private String getOperationDescription(O operation) {
        StringBuffer result = new StringBuffer();
        result.append(this.uml.getName(operation));
        result.append('(');
        Iterator<PM> iter = this.uml.getParameters(operation).iterator();
        while (iter.hasNext()) {
            PM next = iter.next();
            result.append(this.uml.getName(next));
            if (this.uml.getOCLType(next) != null) {
                result.append(": ");
                result.append(this.getDescription(next));
            }
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        if (this.uml.getOCLType(operation) == null) {
            result.append(')');
        } else {
            result.append(") : ");
            result.append(this.uml.getName(this.uml.getOCLType(operation)));
        }
        return result.toString();
    }

    private String getSignalDescription(C signal) {
        StringBuffer result = new StringBuffer();
        result.append("<<signal>> ");
        result.append(this.uml.getName(signal));
        result.append('(');
        Iterator<P> iter = this.uml.getAttributes(signal).iterator();
        while (iter.hasNext()) {
            P next = iter.next();
            result.append(this.uml.getName(next));
            if (this.uml.getOCLType(next) != null) {
                result.append(": ");
                result.append(this.getDescription(next));
            }
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    private List<Choice> getPropertyChoices(C eClass) {
        ArrayList<Choice> result = new ArrayList<Choice>();
        HashSet properties = new HashSet(TypeUtil.getAttributes(this.environment, eClass));
        for (Object property : properties) {
            String name;
            ChoiceImpl choice;
            result.add(new ChoiceImpl(this.uml.getName(property), this.getDescription(property), ChoiceKind.PROPERTY, property));
            C assocClass = this.uml.getAssociationClass(property);
            if (assocClass == null || result.contains(choice = new ChoiceImpl(name = OCLSyntaxHelper.initialLower(this.uml.getName(assocClass)), this.uml.getName(assocClass), ChoiceKind.ASSOCIATION_CLASS, assocClass))) continue;
            result.add(choice);
        }
        return result;
    }

    public static String initialLower(String name) {
        StringBuffer result = new StringBuffer(name);
        if (result.length() > 0) {
            UnicodeSupport.setCodePointAt(result, 0, UnicodeSupport.toLowerCase(UnicodeSupport.codePointAt(result, 0)));
        }
        return result.toString();
    }

    private List<Choice> getChoices(OCLExpression<C> expression, ConstraintKind constraintType) {
        return this.getChoices(expression.getType(), constraintType);
    }

    /*
     * Unable to fully structure code
     */
    private List<Choice> getChoices(C type, ConstraintKind constraintType) {
        if (!(type instanceof CollectionType)) ** GOTO lbl13
        ct = (CollectionType)type;
        if (this.syntaxHelpStringSuffix == 1) {
            rawChoices = this.getCollectionChoices(type);
        } else {
            if (this.syntaxHelpStringSuffix == 0) {
                elementType = ct.getElementType();
                while (elementType instanceof CollectionType) {
                    elementType = ct.getElementType();
                }
                return this.getChoices(ct.getElementType(), constraintType);
            }
            return Collections.emptyList();
lbl13:
            // 1 sources

            if (this.syntaxHelpStringSuffix == 1) {
                setType = this.environment.getOCLFactory().createSetType(type);
                return this.getChoices(setType, constraintType);
            }
            if (this.syntaxHelpStringSuffix == 0) {
                rawChoices = this.getPropertyChoices(type);
                rawChoices.addAll(this.getOperationChoices(type));
            } else if (this.syntaxHelpStringSuffix == 3) {
                rawChoices = this.getOperationChoices(type);
                rawChoices.addAll(this.getReceptionChoices(type));
            } else {
                return Collections.emptyList();
            }
        }
        return this.filter(rawChoices, constraintType);
    }

    private List<Choice> filter(List<Choice> choices, ConstraintKind constraintType) {
        List<Choice> result = choices;
        Iterator<Choice> iter = choices.iterator();
        block3: while (iter.hasNext()) {
            Choice next = iter.next();
            switch (constraintType) {
                case INVARIANT: 
                case PRECONDITION: 
                case BODYCONDITION: {
                    if ("oclIsNew".equals(next.getName())) {
                        iter.remove();
                        break;
                    }
                }
                default: {
                    if (INFIX_OPERATORS.contains(next.getName())) {
                        iter.remove();
                        break;
                    }
                    if (this.syntaxHelpStringSuffix != 3 || !ANY_TYPE_OPERATIONS.contains(next.getName())) continue block3;
                    iter.remove();
                }
            }
        }
        return result;
    }

    private List<Choice> getPathChoices(List<String> path) throws Exception {
        if (!path.isEmpty()) {
            PK ePackage = this.environment.lookupPackage(path);
            if (ePackage != null) {
                return this.getPackageChoices(ePackage);
            }
            C type = this.environment.lookupClassifier(path);
            if (this.uml.isEnumeration(type)) {
                return this.getEnumerationChoices(type);
            }
        }
        return Collections.emptyList();
    }

    private List<Choice> getStateChoices(C owner, List<String> pathPrefix) throws Exception {
        List<Choice> result;
        List<S> states = this.environment.getStates(owner, pathPrefix);
        if (states.isEmpty()) {
            result = Collections.emptyList();
        } else {
            LinkedHashSet<ChoiceImpl> choices = new LinkedHashSet<ChoiceImpl>();
            for (S next : states) {
                choices.add(new ChoiceImpl(this.uml.getName(next), this.uml.getName(this.stdlib.getState()), ChoiceKind.STATE, next));
            }
            result = new ArrayList<Choice>(choices);
        }
        return result;
    }

    private List<Choice> getEnumerationChoices(C type) {
        ArrayList<Choice> result = new ArrayList<Choice>();
        for (EL literal : this.uml.getEnumerationLiterals(type)) {
            result.add(new ChoiceImpl(this.uml.getName(literal), this.getDescription(literal), ChoiceKind.ENUMERATION_LITERAL, literal));
        }
        return result;
    }

    private List<Choice> getPackageChoices(PK ePackage) {
        LinkedHashSet<ChoiceImpl> choices = new LinkedHashSet<ChoiceImpl>();
        for (PK nested : this.uml.getNestedPackages(ePackage)) {
            choices.add(new ChoiceImpl(this.uml.getName(nested), this.getDescription(nested), ChoiceKind.PACKAGE, nested));
        }
        for (Object classifier : this.uml.getClassifiers(ePackage)) {
            choices.add(new ChoiceImpl(this.uml.getName(classifier), this.getDescription(classifier), ChoiceKind.TYPE, classifier));
        }
        return new ArrayList<Choice>(choices);
    }

    private List<Choice> getVariableChoices(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String txt, ConstraintKind constraintType) {
        LinkedHashSet<Choice> choices = new LinkedHashSet<Choice>();
        int oldSuffix = this.syntaxHelpStringSuffix;
        this.syntaxHelpStringSuffix = 0;
        choices.addAll(this.getChoices(env.getSelfVariable().getType(), constraintType));
        this.syntaxHelpStringSuffix = oldSuffix;
        List<IToken> tokens = this.tokenize(txt);
        try {
            this.getVariables(env, txt, tokens.listIterator(tokens.size()));
        }
        catch (Exception exception) {}
        for (Variable<C, PM> var : env.getVariables()) {
            choices.add(new ChoiceImpl(var.getName(), this.uml.getName(var.getType()), ChoiceKind.VARIABLE, var));
        }
        return this.filter(new ArrayList<Choice>(choices), constraintType);
    }

    private List<Choice> getPartialNameChoices(String text, ConstraintKind constraintType, int position) {
        List<Choice> result = this.getSyntaxHelp(constraintType, text.substring(0, position));
        String partial = text.substring(position).trim();
        int length = partial.length();
        Iterator<Choice> iter = result.iterator();
        while (iter.hasNext()) {
            Choice next = iter.next();
            if (next.getName().regionMatches(true, 0, partial, 0, length)) continue;
            iter.remove();
        }
        return result;
    }

    private int tokenAt(String text, int tokenIndex) {
        int result = 74;
        List<IToken> tokens = this.tokenize(text);
        if (tokenIndex < 0) {
            tokenIndex = tokens.size() + tokenIndex;
        }
        if (tokenIndex >= 0 && tokenIndex < tokens.size()) {
            result = tokens.get(tokenIndex).getKind();
        }
        return result;
    }

    private List<IToken> tokenize(String text) {
        OCLLexer lexer = new OCLLexer(text.toCharArray());
        return this.tokenize(new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, this.environment));
    }

    private List<IToken> tokenize(OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser) {
        IToken token = null;
        ArrayList<IToken> result = new ArrayList<IToken>();
        try {
            while ((token = parser.getIToken(parser.getToken())).getKind() != 74) {
                result.add(token);
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private String getDescription(Object namedElement) {
        return this.uml.getDescription(namedElement);
    }

    List<Choice> getSyntaxHelp(ConstraintKind constraintType, String txt) {
        try {
            List<Choice> choices;
            List<Choice> choices2;
            List<String> pathNames;
            txt = txt.trim();
            if (txt.endsWith(".")) {
                this.syntaxHelpStringSuffix = 0;
                int position = txt.lastIndexOf(".");
                return (List)this.getOCLExpression(this.environment, position, txt, constraintType).accept(new ASTVisitor(txt, position, constraintType));
            }
            if (txt.endsWith("->")) {
                this.syntaxHelpStringSuffix = 1;
                int position = txt.lastIndexOf("->");
                return (List)this.getOCLExpression(this.environment, position, txt, constraintType).accept(new ASTVisitor(txt, position, constraintType));
            }
            if (txt.endsWith("^")) {
                this.syntaxHelpStringSuffix = 3;
                int position = txt.endsWith("^^") ? txt.length() - 2 : txt.length() - 1;
                return (List)this.getOCLExpression(this.environment, position, txt, constraintType).accept(new ASTVisitor(txt, position, constraintType));
            }
            if (txt.endsWith("::")) {
                this.syntaxHelpStringSuffix = -1;
                int position = txt.length() - 2;
                ArrayList<String> pathName = new ArrayList<String>();
                OCLLexer lexer = new OCLLexer(txt.toCharArray());
                OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, this.environment);
                List<IToken> tokens = this.tokenize(parser);
                ListIterator<IToken> iter = tokens.listIterator(tokens.size());
                while (iter.hasPrevious() && this.syntaxHelpStringSuffix == -1) {
                    IToken prev = iter.previous();
                    switch (prev.getKind()) {
                        case 1: {
                            if (iter.hasPrevious() && (prev = iter.previous()).getKind() == 58) {
                                this.syntaxHelpStringSuffix = 4;
                                position = prev.getStartOffset();
                                break;
                            }
                            this.syntaxHelpStringSuffix = 2;
                            break;
                        }
                        case 3: {
                            pathName.add(0, parser.getTokenText(prev.getTokenIndex()));
                            break;
                        }
                        case 67: {
                            break;
                        }
                        default: {
                            this.syntaxHelpStringSuffix = 2;
                        }
                    }
                }
                if (this.syntaxHelpStringSuffix == 4) {
                    Object sourceType = this.getOCLExpression(this.environment, txt.lastIndexOf(".", position), txt, constraintType).getType();
                    return this.getStateChoices(sourceType, pathName);
                }
                return this.getPathChoices(pathName);
            }
            if (txt.endsWith("(") && this.tokenAt(txt, -2) == 58) {
                this.syntaxHelpStringSuffix = 4;
                Object sourceType = this.getOCLExpression(this.environment, txt.lastIndexOf("."), txt, constraintType).getType();
                List<String> empty = Collections.emptyList();
                return this.getStateChoices(sourceType, empty);
            }
            OCLLexer lexer = new OCLLexer(txt.toCharArray());
            OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, this.environment);
            List<IToken> tokens = this.tokenize(parser);
            if (tokens.size() > 2) {
                IToken last = tokens.get(tokens.size() - 1);
                IToken prev = tokens.get(tokens.size() - 2);
                if (OCLParser.isIdentifierOrKeyword(last.getKind())) {
                    switch (prev.getKind()) {
                        case 67: 
                        case 83: 
                        case 85: {
                            return this.getPartialNameChoices(txt, constraintType, prev.getEndOffset() + 1);
                        }
                    }
                }
            }
            if (tokens.size() > 1 && !(pathNames = this.parseTokensPathNameCS(parser, tokens)).isEmpty() && !(choices2 = this.getPartialNameChoices(txt, constraintType, txt.lastIndexOf("::") + "::".length())).isEmpty()) {
                return choices2;
            }
            if (tokens.size() > 0 && tokens.get(tokens.size() - 1).getKind() == 3 && !(choices = this.getPartialNameChoices(txt, constraintType, tokens.get(tokens.size() - 1).getStartOffset())).isEmpty()) {
                return choices;
            }
            this.syntaxHelpStringSuffix = -1;
            Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> copy = this.copyEnvironment(this.environment);
            return this.getVariableChoices(copy, txt, constraintType);
        }
        catch (Exception exception) {
            Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> copy = this.copyEnvironment(this.environment);
            return this.getVariableChoices(copy, txt, constraintType);
        }
    }

    private List<String> parseTokensPathNameCS(OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser, List<IToken> tokens) {
        ArrayList<String> path = new ArrayList<String>();
        int index = tokens.size() - 1;
        boolean doubleColon = false;
        while (index >= 0) {
            IToken token = tokens.get(index--);
            if (!doubleColon || token.getKind() != 67) {
                if (doubleColon || token.getKind() != 3) break;
                path.add(0, parser.getTokenText(token.getTokenIndex()));
            }
            boolean bl = doubleColon = !doubleColon;
        }
        return path;
    }

    private OCLExpression<C> getOCLExpression(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, int index, String txt, ConstraintKind constraintType) throws Exception {
        env = this.copyEnvironment(env);
        int start = 0;
        int end = index;
        String newTxt = txt.substring(start, end);
        OCLLexer lexer = new OCLLexer(newTxt.toCharArray());
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, env);
        PackageDeclarationCS packageContext = null;
        OCLExpressionCS cst = null;
        lexer.reset();
        List<IToken> tokens = this.tokenize(parser);
        ListIterator<IToken> it = tokens.listIterator(tokens.size());
        int offset = -"context foo inv: ".length();
        int[] balance = new int[1];
        int i = 0;
        while (it.hasPrevious() && i < 100) {
            block9: {
                IToken token = it.previous();
                while (this.updateBalance(balance, token) > 0 && it.hasPrevious()) {
                    token = it.previous();
                }
                boolean tryParse = true;
                if (this.isBoundaryToken(token)) break;
                if (it.hasPrevious()) {
                    IToken bdry = it.previous();
                    int oldBalance = balance[0];
                    if (this.isBoundaryToken(bdry) || this.updateBalance(balance, bdry) < 0) {
                        tryParse = true;
                    } else {
                        tryParse = false;
                        it.next();
                        balance[0] = oldBalance;
                    }
                }
                if (tryParse) {
                    try {
                        start = token.getStartOffset();
                        newTxt = "context foo inv: " + txt.substring(start, end);
                        lexer = new OCLLexer(newTxt.toCharArray());
                        parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, env);
                        parser.setCharacterOffset(offset + start);
                        packageContext = (PackageDeclarationCS)parser.parseConcreteSyntax();
                        ClassifierContextDeclCS context = (ClassifierContextDeclCS)packageContext.getContextDecls().get(0);
                        cst = ((InvCS)context.getInvOrDefCS()).getExpressionCS();
                    }
                    catch (ParserException parserException) {
                        if (balance[0] >= 0) break block9;
                    }
                    break;
                }
            }
            ++i;
        }
        if (cst != null && start >= 0) {
            it.next();
            this.getVariables(env, txt.substring(0, start), it);
            return parser.parseAST(cst, constraintType);
        }
        return null;
    }

    private boolean isBoundaryToken(IToken token) {
        switch (token.getKind()) {
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 68: 
            case 70: 
            case 71: 
            case 84: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                return true;
            }
        }
        return false;
    }

    private int updateBalance(int[] balance, IToken token) {
        switch (token.getKind()) {
            case 1: 
            case 69: 
            case 81: {
                balance[0] = balance[0] - 1;
                break;
            }
            case 2: 
            case 75: 
            case 80: {
                balance[0] = balance[0] + 1;
            }
        }
        return balance[0];
    }

    private void getVariables(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String text, ListIterator<IToken> tokens) throws ParserException {
        IToken token = null;
        while (tokens.hasPrevious()) {
            IToken ot;
            int beginIndex;
            token = tokens.previous();
            if (token.getKind() == 71) {
                beginIndex = 0;
                while (tokens.hasPrevious()) {
                    ot = tokens.previous();
                    if (ot.getKind() != 1) continue;
                    beginIndex = ot.getEndOffset() + 1;
                    break;
                }
                this.parseIterators(env, text.substring(beginIndex, token.getStartOffset()));
                continue;
            }
            if (token.getKind() != 96) continue;
            beginIndex = 0;
            while (tokens.hasPrevious()) {
                ot = tokens.previous();
                if (ot.getKind() != 68) continue;
                beginIndex = ot.getEndOffset() + 1;
                break;
            }
            this.parseVariable(env, text.substring(beginIndex, token.getStartOffset()));
        }
    }

    private void parseIterators(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String variables) throws ParserException {
        int beginIndex = 0;
        OCLLexer mainLexer = new OCLLexer(variables.toCharArray());
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> mainParser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(mainLexer, env);
        if (!this.parseVariableDeclaration(env, mainParser)) {
            mainParser.reset();
            IToken token = mainParser.getIToken(mainParser.getToken());
            while (token.getKind() != 74) {
                String newTxt;
                OCLLexer lexer;
                OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser;
                if ((token.getKind() == 36 || token.getKind() == 84) && this.parseVariableDeclaration(env, parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer = new OCLLexer((newTxt = variables.substring(beginIndex, token.getStartOffset())).toCharArray()), env)) && this.parseVariableDeclaration(env, parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer = new OCLLexer((newTxt = variables.substring(beginIndex = token.getEndOffset() + 1)).toCharArray()), env))) break;
                token = mainParser.getIToken(mainParser.getToken());
            }
        }
    }

    private void parseVariable(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String variables) throws ParserException {
        OCLLexer lexer = new OCLLexer(variables.toCharArray());
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, env);
        this.parseVariableDeclaration(env, parser);
    }

    private boolean parseVariableDeclaration(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> p) {
        try {
            p.parseVariableDeclarationCS(true);
            return true;
        }
        catch (SemanticException semanticException) {
            return true;
        }
        catch (ParserException parserException) {
            return false;
        }
    }

    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> copyEnvironment(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        return env.getFactory().createEnvironment(env);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ASTVisitor
    implements Visitor<List<Choice>, C, O, P, EL, PM, S, COA, SSA, CT> {
        private final int completionPosition;
        private final String text;
        private final ConstraintKind constraintType;

        ASTVisitor(String text, int position, ConstraintKind constraintType) {
            this.text = text;
            this.completionPosition = position;
            this.constraintType = constraintType;
        }

        @Override
        public List<Choice> visitOperationCallExp(OperationCallExp<C, O> exp) {
            OCLExpression last;
            List args;
            if (exp.getEndPosition() == this.completionPosition && !(args = (List)exp.getArgument()).isEmpty() && (last = (OCLExpression)args.get(args.size() - 1)).getEndPosition() == this.completionPosition) {
                return (List)last.accept(this);
            }
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitVariableExp(VariableExp<C, PM> variableexp) {
            return OCLSyntaxHelper.this.getChoices((Object)variableexp, this.constraintType);
        }

        @Override
        public List<Choice> visitPropertyCallExp(PropertyCallExp<C, P> propertycallexp) {
            return OCLSyntaxHelper.this.getChoices((Object)propertycallexp, this.constraintType);
        }

        @Override
        public List<Choice> visitAssociationClassCallExp(AssociationClassCallExp<C, P> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitVariable(Variable<C, PM> variabledeclaration) {
            return Collections.emptyList();
        }

        @Override
        public List<Choice> visitIfExp(IfExp<C> exp) {
            int lastCharPos = UnicodeSupport.shiftCodePointOffsetBy(this.text, exp.getEndPosition(), -1);
            if (this.text.charAt(lastCharPos) == ')') {
                return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
            }
            return Collections.emptyList();
        }

        @Override
        public List<Choice> visitTypeExp(TypeExp<C> typeExp) {
            return OCLSyntaxHelper.this.getOperationChoices(typeExp.getType());
        }

        @Override
        public List<Choice> visitMessageExp(MessageExp<C, COA, SSA> m) {
            return OCLSyntaxHelper.this.getChoices((Object)m, this.constraintType);
        }

        @Override
        public List<Choice> visitUnspecifiedValueExp(UnspecifiedValueExp<C> unspecifiedvalueexp) {
            return OCLSyntaxHelper.this.getChoices((Object)unspecifiedvalueexp, this.constraintType);
        }

        @Override
        public List<Choice> visitIntegerLiteralExp(IntegerLiteralExp<C> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<C> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitRealLiteralExp(RealLiteralExp<C> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitStringLiteralExp(StringLiteralExp<C> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitBooleanLiteralExp(BooleanLiteralExp<C> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitNullLiteralExp(NullLiteralExp<C> il) {
            return OCLSyntaxHelper.this.getAnyChoices();
        }

        @Override
        public List<Choice> visitInvalidLiteralExp(InvalidLiteralExp<C> il) {
            return OCLSyntaxHelper.this.getAnyChoices();
        }

        @Override
        public List<Choice> visitTupleLiteralExp(TupleLiteralExp<C, P> tupleliteralexp) {
            return OCLSyntaxHelper.this.getChoices((Object)tupleliteralexp, this.constraintType);
        }

        @Override
        public List<Choice> visitTupleLiteralPart(TupleLiteralPart<C, P> tp) {
            return Collections.emptyList();
        }

        @Override
        public List<Choice> visitLetExp(LetExp<C, PM> letexp) {
            return OCLSyntaxHelper.this.getChoices(letexp.getType(), this.constraintType);
        }

        @Override
        public List<Choice> visitEnumLiteralExp(EnumLiteralExp<C, EL> enumliteralexp) {
            return OCLSyntaxHelper.this.getChoices((Object)enumliteralexp, this.constraintType);
        }

        @Override
        public List<Choice> visitStateExp(StateExp<C, S> s) {
            return OCLSyntaxHelper.this.getChoices((Object)s, this.constraintType);
        }

        @Override
        public List<Choice> visitCollectionLiteralExp(CollectionLiteralExp<C> exp) {
            return OCLSyntaxHelper.this.getChoices((Object)exp, this.constraintType);
        }

        @Override
        public List<Choice> visitCollectionItem(CollectionItem<C> item) {
            return (List)item.getItem().accept(this);
        }

        @Override
        public List<Choice> visitCollectionRange(CollectionRange<C> range) {
            return (List)range.getLast().accept(this);
        }

        @Override
        public List<Choice> visitIteratorExp(IteratorExp<C, PM> exp) {
            if (exp.getEndPosition() == this.completionPosition) {
                return OCLSyntaxHelper.this.getChoices(exp.getType(), this.constraintType);
            }
            return (List)exp.getBody().accept(this);
        }

        @Override
        public List<Choice> visitIterateExp(IterateExp<C, PM> exp) {
            if (exp.getEndPosition() == this.completionPosition) {
                return OCLSyntaxHelper.this.getChoices(exp.getType(), this.constraintType);
            }
            return (List)exp.getBody().accept(this);
        }

        @Override
        public List<Choice> visitExpressionInOCL(ExpressionInOCL<C, PM> expression) {
            return Collections.emptyList();
        }

        @Override
        public List<Choice> visitConstraint(CT constraint) {
            return Collections.emptyList();
        }
    }
}

