/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public class Trace {
    public static final byte CONFIG = 0;
    public static final byte INFO = 1;
    public static final byte WARNING = 2;
    public static final byte SEVERE = 3;
    public static final byte FINEST = 4;
    public static final byte FINER = 5;
    public static final byte PERFORMANCE = 6;
    public static final byte EXTENSION_POINT = 7;
    protected static int pluginLength = -1;
    private static final String[] levelNames = new String[]{"CONFIG ", "INFO   ", "WARNING", "SEVERE ", "FINER  ", "FINEST ", "PERF   ", "EXTENSION"};
    private static final String spacer = "                                   ";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");

    private Trace() {
    }

    public static void trace(byte level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(byte level, String s, Throwable t) {
        if (!ServerUIPlugin.getInstance().isDebugging()) {
            return;
        }
        String pluginId = "org.eclipse.wst.server.ui";
        StringBuffer sb = new StringBuffer(pluginId);
        if (pluginId.length() > pluginLength) {
            pluginLength = pluginId.length();
        } else if (pluginId.length() < pluginLength) {
            sb.append(spacer.substring(0, pluginLength - pluginId.length()));
        }
        sb.append(" ");
        sb.append(levelNames[level]);
        sb.append(" ");
        sb.append(sdf.format(new Date()));
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }
}

