/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class DefaultViewerSorter
extends ViewerSorter {
    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof AbstractTreeContentProvider.TreeElement) {
            o1 = ((AbstractTreeContentProvider.TreeElement)o1).text;
        }
        if (o2 instanceof AbstractTreeContentProvider.TreeElement) {
            o2 = ((AbstractTreeContentProvider.TreeElement)o2).text;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return this.compareCategories((String)o1, (String)o2);
        }
        if (o1 instanceof String) {
            return -1;
        }
        if (o2 instanceof String) {
            return 1;
        }
        if (o1 instanceof IRuntimeType && o2 instanceof IRuntimeType) {
            return this.compareRuntimeTypes((IRuntimeType)o1, (IRuntimeType)o2);
        }
        if (o1 instanceof IServerType && o2 instanceof IServerType) {
            return this.compareServerTypes((IServerType)o1, (IServerType)o2);
        }
        return 0;
    }

    protected int compareCategories(String s1, String s2) {
        try {
            Version v1 = Version.parseVersion(s1);
            Version v2 = Version.parseVersion(s2);
            return v1.compareTo(v2);
        }
        catch (NumberFormatException numberFormatException) {
            return s1.compareTo(s2);
        }
    }

    protected boolean isSameFamily(String s1, String v1, String s2, String v2) {
        int ind;
        if (s1 == null || s2 == null) {
            return false;
        }
        if (v1 != null && (ind = s1.indexOf(v1)) >= 0) {
            s1 = String.valueOf(s1.substring(0, ind)) + s1.substring(ind + v1.length());
        }
        if (v2 != null && (ind = s2.indexOf(v2)) >= 0) {
            s2 = String.valueOf(s2.substring(0, ind)) + s2.substring(ind + v2.length());
        }
        return s1.equals(s2);
    }

    protected int compareVersions(String s1, String s2) {
        Version v1 = Version.parseVersion(s1);
        Version v2 = Version.parseVersion(s2);
        return v1.compareTo(v2);
    }

    protected int compareRuntimeTypes(IRuntimeType r1, IRuntimeType r2) {
        if (this.isSameFamily(r1.getName(), r1.getVersion(), r2.getName(), r2.getVersion())) {
            return this.compareVersions(r1.getVersion(), r2.getVersion());
        }
        return r1.getName().compareToIgnoreCase(r2.getName());
    }

    protected int compareServerTypes(IServerType s1, IServerType s2) {
        IRuntimeType r1 = s1.getRuntimeType();
        IRuntimeType r2 = s2.getRuntimeType();
        if (r1 != null && r2 != null && this.isSameFamily(s1.getName(), r1.getVersion(), s2.getName(), r2.getVersion())) {
            return this.compareVersions(r1.getVersion(), r2.getVersion());
        }
        return s1.getName().compareToIgnoreCase(s2.getName());
    }

    public static class Version
    implements Comparable {
        private static final String SEPARATORS = ".,";
        private final String[] segments;

        private Version(String[] segments) {
            this.segments = segments;
        }

        public static Version parseVersion(String version) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(version, SEPARATORS, false);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return new Version(s);
        }

        private int compareTo(String s1, String s2) {
            int i2;
            int i1;
            block4: {
                try {
                    i1 = Integer.parseInt(s1);
                    i2 = Integer.parseInt(s2);
                    if (i1 != i2) break block4;
                    return 0;
                }
                catch (Exception exception) {
                    return s1.compareTo(s2);
                }
            }
            if (i1 > i2) {
                return 1;
            }
            return -1;
        }

        public int compareTo(Object object) {
            if (object == this) {
                return 0;
            }
            Version other = (Version)object;
            int i = 0;
            while (i < this.segments.length && i < other.segments.length) {
                String s1 = this.segments[i];
                String s2 = other.segments[i];
                int c = this.compareTo(s1, s2);
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            if (i == this.segments.length && i == other.segments.length) {
                return 0;
            }
            if (i == this.segments.length) {
                return -1;
            }
            return 1;
        }
    }
}

