/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Animator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateManager;

public class Animation {
    private static final int DEFAULT_DELAY = 250;
    private static Set figureAnimators;
    private static Map finalStates;
    private static Map initialStates;
    private static final int PLAYBACK = 3;
    private static float progress;
    private static final int RECORD_FINAL = 2;
    private static final int RECORD_INITIAL = 1;
    private static long startTime;
    private static int state;
    private static Set toCapture;
    private static UpdateManager updateManager;

    private static void capture() {
        Iterator keys = figureAnimators.iterator();
        while (keys.hasNext()) {
            AnimPair pair = (AnimPair)keys.next();
            if (toCapture.contains(pair)) {
                pair.animator.capture(pair.figure);
                continue;
            }
            keys.remove();
        }
    }

    static void cleanup() {
        if (figureAnimators != null) {
            Iterator keys = figureAnimators.iterator();
            while (keys.hasNext()) {
                AnimPair pair = (AnimPair)keys.next();
                pair.animator.tearDown(pair.figure);
            }
        }
        state = 0;
        Animation.step();
        initialStates = null;
        finalStates = null;
        figureAnimators = null;
        updateManager = null;
        toCapture = null;
        state = 0;
    }

    private static void doRun(int duration) {
        state = 2;
        Animation.findUpdateManager();
        updateManager.performValidation();
        Animation.capture();
        state = 3;
        progress = 0.1f;
        startTime = System.currentTimeMillis();
        Animation.notifyPlaybackStarting();
        while (progress != 0.0f) {
            int delta;
            Animation.step();
            updateManager.performUpdate();
            progress = (double)progress == 1.0 ? 0.0f : ((delta = (int)(System.currentTimeMillis() - startTime)) >= duration ? 1.0f : 0.1f + 0.9f * (float)delta / (float)duration);
        }
    }

    private static void findUpdateManager() {
        AnimPair pair = (AnimPair)figureAnimators.iterator().next();
        updateManager = pair.figure.getUpdateManager();
    }

    public static Object getFinalState(Animator animator, IFigure figure) {
        return finalStates.get(new AnimPair(animator, figure));
    }

    public static Object getInitialState(Animator animator, IFigure figure) {
        return initialStates.get(new AnimPair(animator, figure));
    }

    public static float getProgress() {
        return progress;
    }

    static void hookAnimator(IFigure figure, Animator animator) {
        AnimPair pair = new AnimPair(animator, figure);
        if (figureAnimators.add(pair)) {
            animator.init(figure);
        }
    }

    static void hookNeedsCapture(IFigure figure, Animator animator) {
        AnimPair pair = new AnimPair(animator, figure);
        if (figureAnimators.contains(pair)) {
            toCapture.add(pair);
        }
    }

    static boolean hookPlayback(IFigure figure, Animator animator) {
        if (toCapture.contains(new AnimPair(animator, figure))) {
            return animator.playback(figure);
        }
        return false;
    }

    public static boolean isAnimating() {
        return state == 3;
    }

    static boolean isFinalRecording() {
        return state == 2;
    }

    static boolean isInitialRecording() {
        return state == 1;
    }

    public static boolean markBegin() {
        if (state == 0) {
            state = 1;
            initialStates = new HashMap();
            finalStates = new HashMap();
            figureAnimators = new HashSet();
            toCapture = new HashSet();
            return true;
        }
        return false;
    }

    private static void notifyPlaybackStarting() {
        Iterator keys = figureAnimators.iterator();
        while (keys.hasNext()) {
            AnimPair pair = (AnimPair)keys.next();
            pair.animator.playbackStarting(pair.figure);
        }
    }

    static void putFinalState(Animator animator, IFigure key, Object state) {
        finalStates.put(new AnimPair(animator, key), state);
    }

    static void putInitialState(Animator animator, IFigure key, Object state) {
        initialStates.put(new AnimPair(animator, key), state);
    }

    public static void run() {
        Animation.run(250);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(int duration) {
        if (state == 0) {
            return;
        }
        try {
            if (!figureAnimators.isEmpty()) {
                Animation.doRun(duration);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Animation.cleanup();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        Animation.cleanup();
    }

    private static void step() {
        Iterator iter = initialStates.keySet().iterator();
        while (iter.hasNext()) {
            ((AnimPair)iter.next()).figure.revalidate();
        }
    }

    static class AnimPair {
        final Animator animator;
        final IFigure figure;

        AnimPair(Animator animator, IFigure figure) {
            this.animator = animator;
            this.figure = figure;
        }

        public boolean equals(Object obj) {
            AnimPair pair = (AnimPair)obj;
            return pair.animator == this.animator && pair.figure == this.figure;
        }

        public int hashCode() {
            return this.animator.hashCode() ^ this.figure.hashCode();
        }
    }
}

