/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.datamodel;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Connection;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Rel;

public class BasicRel
implements Rel {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String fName;
    private Element fSourceElement;
    private Vector fConnections;

    public BasicRel(String name, Element sourceElement) {
        this.fName = name;
        this.fSourceElement = sourceElement;
        this.fConnections = new Vector();
    }

    public String getName() {
        return this.fName;
    }

    public Element getSourceElement() {
        return this.fSourceElement;
    }

    public Enumeration getTargetElements() {
        return new ElementEnumeration(this.fConnections.elements());
    }

    public int getNumberOfTargetElements() {
        return this.fConnections.size();
    }

    public void addConnection(Connection connection) {
        this.fConnections.addElement(connection);
    }

    public boolean removeConnection(Connection connection) {
        return this.fConnections.removeElement(connection);
    }

    public Connection getConnectionTo(Element targetElement) {
        Enumeration e = this.fConnections.elements();
        while (e.hasMoreElements()) {
            Connection c = (Connection)e.nextElement();
            if (c.getElement() != targetElement) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private class ElementEnumeration
    implements Enumeration {
        private Enumeration fConnectionEnumeration;

        public ElementEnumeration(Enumeration connectionEnumeration) {
            this.fConnectionEnumeration = connectionEnumeration;
        }

        public boolean hasMoreElements() {
            return this.fConnectionEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            return ((Connection)this.fConnectionEnumeration.nextElement()).getElement();
        }
    }
}

