/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.actions;

import org.eclipse.gef.examples.text.actions.StyleListener;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;

public class BooleanStyleAction
extends Action {
    protected String property;
    protected StyleService service;
    private StyleListener styleListener = new StyleListener(){

        public void styleChanged(String styleID) {
            if (styleID == null || styleID.equals(BooleanStyleAction.this.getId())) {
                BooleanStyleAction.this.refresh();
            }
        }
    };

    public BooleanStyleAction(StyleService service, String styleID, String property) {
        this.setStyleService(service);
        this.setId(styleID);
        this.property = property;
        BooleanStyleAction.configureStyleAction((IAction)this);
    }

    protected boolean calculateEnabled() {
        return this.service.getStyleState(this.getId()) == StyleService.STATE_EDITABLE;
    }

    static void configureStyleAction(IAction a) {
        String styleID = a.getId();
        a.setActionDefinitionId(styleID);
        if (styleID.equals("org.eclipse.gef.text.bold")) {
            a.setText("Bold");
            a.setImageDescriptor(InternalImages.DESC_BOLD);
        } else if (styleID.equals("org.eclipse.gef.text.italic")) {
            a.setText("Italics");
            a.setImageDescriptor(InternalImages.DESC_ITALIC);
        } else if (styleID.equals("org.eclipse.gef.text.underline")) {
            a.setText("Underline");
            a.setImageDescriptor(InternalImages.DESC_UNDERLINE);
        } else if (styleID.equals("org.eclipse.gef.text.alignCenter")) {
            a.setText("Center");
            a.setImageDescriptor(InternalImages.DESC_BLOCK_ALIGN_CENTER);
        } else if (styleID.equals("org.eclipse.gef.text.alignLeft")) {
            a.setText("Left");
            a.setImageDescriptor(InternalImages.DESC_BLOCK_ALIGN_LEFT);
        } else if (styleID.equals("org.eclipse.gef.text.alignRight")) {
            a.setText("Right");
            a.setImageDescriptor(InternalImages.DESC_BLOCK_ALIGN_RIGHT);
        } else if (styleID.equals("org.eclipse.gef.text.ltr")) {
            a.setText("Left to Right");
            a.setImageDescriptor(InternalImages.DESC_BLOCK_LTR);
        } else if (styleID.equals("org.eclipse.gef.text.rtl")) {
            a.setText("Right to Left");
            a.setImageDescriptor(InternalImages.DESC_BLOCK_RTL);
        } else {
            throw new RuntimeException("The given style ID was not recognized");
        }
    }

    public void run() {
        this.service.setStyle(this.property, this.isChecked() ? Boolean.TRUE : Boolean.FALSE);
    }

    private void setStyleService(StyleService styleService) {
        Assert.isNotNull((Object)styleService);
        this.service = styleService;
        this.service.addStyleListener(this.styleListener);
    }

    public void refresh() {
        this.setChecked(this.service.getStyle(this.property).equals(Boolean.TRUE));
        this.setEnabled(this.service.getStyleState(this.property).equals(StyleService.STATE_EDITABLE));
    }
}

