/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteElementTemplateHelper;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationAttribute;
import org.eclipse.jst.pagedesigner.editors.palette.paletteinfos.TagCreationInfo;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.internal.AbstractCreationCommand;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCustomizationCommand
extends AbstractCreationCommand {
    protected final IDOMModel _model;
    protected final Element _element;
    protected final CreationData _creationData;

    public ElementCustomizationCommand(IDOMModel model, Element element, CreationData creationData) {
        this._model = model;
        this._element = element;
        this._creationData = creationData;
    }

    @Override
    public void execute() {
        this.applyChildElementCustomization();
        this.applyAttributeCustomization();
    }

    @Override
    protected boolean prepare() {
        return true;
    }

    protected void applyChildElementCustomization() {
        TagCreationInfo tagCreationInfo = this._creationData.getTagCreationInfo();
        if (tagCreationInfo != null) {
            PaletteElementTemplateHelper.applyTemplate(this._model, this._element, this._creationData.getTagEntry(), tagCreationInfo);
        }
    }

    protected final void ensureRequiredAttrs(Element element, CreationData creationData) {
        CMElementDeclaration ed = CMUtil.getTLDElementDeclaration((String)creationData.getUri(), (String)creationData.getTagName(), (IDocument)creationData.getModel().getDocument().getStructuredDocument());
        if (ed != null) {
            for (CMAttributeDeclaration attr : ed.getAttributes()) {
                if (attr.getUsage() != 2 || element.getAttribute(attr.getAttrName()) != null) continue;
                element.setAttribute(attr.getAttrName(), attr.getDefaultValue());
            }
        }
    }

    protected void applyAttributeCustomization() {
        EList list;
        TagCreationInfo info = this._creationData.getTagCreationInfo();
        if (info != null && (list = info.getAttributes()) != null) {
            for (TagCreationAttribute attr : list) {
                this._element.setAttribute(attr.getId(), attr.getValue() == null ? "" : attr.getValue());
            }
        }
    }

    @Override
    public final Command chain(Command command) {
        return super.chain(command);
    }

    public final Collection<Element> getResult() {
        return Collections.singletonList(this._element);
    }
}

