/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LayoutUtil {
    private static final int BUTTON_HEIGHT_ADJUSTMENT = 5;

    public static Control createEmptySpace(FormToolkit kit, Composite parent, int span) {
        Label label = kit != null ? kit.createLabel(parent, "") : new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    public static Composite createComposite(FormToolkit kit, Composite parent, int span, int internalSpan) {
        Composite c;
        if (kit != null) {
            c = kit.createComposite(parent);
            kit.paintBordersFor(c);
        } else {
            c = new Composite(parent, 0);
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        c.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = internalSpan;
        c.setLayout((Layout)layout);
        return c;
    }

    public static int getNumberOfColumns(DialogField[] editors) {
        int nCulumns = 0;
        int i = 0;
        while (i < editors.length) {
            nCulumns = Math.max(editors[i].getNumberOfControls(), nCulumns);
            ++i;
        }
        return nCulumns;
    }

    public static void doDefaultLayout(FormToolkit toolkit, Composite parent, DialogField[] editors, boolean labelOnTop) {
        LayoutUtil.doDefaultLayout(toolkit, parent, editors, labelOnTop, 0, 0, 0, 0);
    }

    public static void doDefaultLayout(FormToolkit toolkit, Composite parent, DialogField[] editors, boolean labelOnTop, int minWidth, int minHeight) {
        LayoutUtil.doDefaultLayout(toolkit, parent, editors, labelOnTop, minWidth, minHeight, 0, 0);
    }

    public static void doDefaultLayout(FormToolkit toolkit, Composite parent, DialogField[] editors, boolean labelOnTop, int minWidth, int minHeight, int marginWidth, int marginHeight) {
        int nCulumns = LayoutUtil.getNumberOfColumns(editors);
        Control[][] controls = new Control[editors.length][];
        int i = 0;
        while (i < editors.length) {
            controls[i] = editors[i].doFillIntoGrid(toolkit, parent, nCulumns);
            ++i;
        }
        if (labelOnTop) {
            LayoutUtil.modifyLabelSpans(controls, --nCulumns);
        }
        GridLayout layout = new GridLayout();
        if (marginWidth != -1) {
            layout.marginWidth = marginWidth;
        }
        if (marginHeight != -1) {
            layout.marginHeight = marginHeight;
        }
        layout.numColumns = nCulumns;
        parent.setLayout((Layout)layout);
    }

    private static void modifyLabelSpans(Control[][] controls, int nCulumns) {
        int i = 0;
        while (i < controls.length) {
            LayoutUtil.setHorizontalSpan(controls[i][0], nCulumns);
            ++i;
        }
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    public static void setGrabHorizontal(Control control, boolean grab) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = grab;
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    public static void setHeigthHint(Control control, int heigthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).heightHint = heigthHint;
        }
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = horizontalIndent;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }

    public static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int length = button.getText().length();
        int widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)(length < 2 ? 2 : length));
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getButtonHeightHint(FormToolkit toolkit, Text text) {
        if (toolkit != null) {
            return text.computeSize((int)-1, (int)-1, (boolean)true).y + 5;
        }
        return text.computeSize((int)-1, (int)-1, (boolean)true).y;
    }
}

