/*******************************************************************************
 * Copyright (c) 2007 BEA Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * BEA Systems, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.classpathdep;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**
 * Holds constants related to classpath component dependencies.
 */
public interface IClasspathDependencyConstants {

	/**
	 * Name of the custom Java classpath entry attribute that is used to flag
	 * entries which should be exposed as module dependencies via the virtual component API. 
	 * The value of the attribute represents the runtime path to which resolved classpath entry components
	 * will be mapped in the deployed/exported module. By default, tagged classpath entries of dynamic web 
	 * projects will be mapped to the /WEB-INF/lib folder of the web project. Tagged classpath entries of
	 * utility, ejb and connector projects will be mapped to either the root of the EAR (if the project is
	 * referenced by an EAR) or to the /WEB-INF/lib directory of the WAR (if the project is a 
	 * web library reference of a web project); the runtime path of "../" is used to represent the mapping
	 * into the referencing module in both of these cases.  
	 * Only container, library and variable entries are currently supported; for containers, only the resolved
	 * entries that are library entries are supported. All resolved entries are mapped unless they have the 
	 * "org.eclipse.jst.component.nondependency" attribute (or are project or lib entries that map to class 
	 * folders which are not currently supported and are therefore always skipped). 
	 */
	public static final String CLASSPATH_COMPONENT_DEPENDENCY = "org.eclipse.jst.component.dependency"; //$NON-NLS-1

	/**
	 * Name of the custom Java classpath entry attribute that is used to flag
	 * the resolved entries of classpath containers that should not be exposed
	 * via the virtual component API.
	 */
	public static final String CLASSPATH_COMPONENT_NON_DEPENDENCY = "org.eclipse.jst.component.nondependency"; //$NON-NLS-1
	
	/**
	 * Runtime path used to indicate that the resolved contributions from a classpath entry should be
	 * mapped into the exported/deployed structure of the parent module at the same location that the target module
	 * is mapped (will be either the EAR root or /WEB-INF/lib).
	 */
	public static final String RUNTIME_MAPPING_INTO_CONTAINER = "../";
	
	/**
	 * IPath value of RUNTIME_MAPPING_INTO_CONTAINER.
	 */
	public static final IPath RUNTIME_MAPPING_INTO_CONTAINER_PATH = new Path(RUNTIME_MAPPING_INTO_CONTAINER);
}
