/**
 * <copyright>
 *
 * Copyright (c) 2002-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EcoreItemProviderAdapterFactory.java,v 1.7 2006/12/28 06:46:20 marcelop Exp $
 */
package org.eclipse.emf.ecore.provider;


import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EcoreAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;


/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EcoreItemProviderAdapterFactory extends EcoreAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EcoreItemProviderAdapterFactory()
  {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EAttribute} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EAttributeItemProvider eAttributeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EAttribute}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEAttributeAdapter()
  {
    if (eAttributeItemProvider == null)
    {
      eAttributeItemProvider = new EAttributeItemProvider(this);
    }

    return eAttributeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EAnnotation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EAnnotationItemProvider eAnnotationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EAnnotation}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEAnnotationAdapter()
  {
    if (eAnnotationItemProvider == null)
    {
      eAnnotationItemProvider = new EAnnotationItemProvider(this);
    }

    return eAnnotationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EClass} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClassItemProvider eClassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EClass}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEClassAdapter()
  {
    if (eClassItemProvider == null)
    {
      eClassItemProvider = new EClassItemProvider(this);
    }

    return eClassItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EDataType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EDataTypeItemProvider eDataTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EDataType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEDataTypeAdapter()
  {
    if (eDataTypeItemProvider == null)
    {
      eDataTypeItemProvider = new EDataTypeItemProvider(this);
    }

    return eDataTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EEnum} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EEnumItemProvider eEnumItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EEnum}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEEnumAdapter()
  {
    if (eEnumItemProvider == null)
    {
      eEnumItemProvider = new EEnumItemProvider(this);
    }

    return eEnumItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EEnumLiteral} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EEnumLiteralItemProvider eEnumLiteralItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EEnumLiteral}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEEnumLiteralAdapter()
  {
    if (eEnumLiteralItemProvider == null)
    {
      eEnumLiteralItemProvider = new EEnumLiteralItemProvider(this);
    }

    return eEnumLiteralItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EFactory} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EFactoryItemProvider eFactoryItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EFactory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEFactoryAdapter()
  {
    if (eFactoryItemProvider == null)
    {
      eFactoryItemProvider = new EFactoryItemProvider(this);
    }

    return eFactoryItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EObject} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected ReflectiveItemProvider eObjectItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EObject}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  @Override
  public Adapter createEObjectAdapter()
  {
    if (eObjectItemProvider == null)
    {
      eObjectItemProvider = new ReflectiveItemProvider(this);
    }

    return eObjectItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EOperation} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EOperationItemProvider eOperationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EOperation}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEOperationAdapter()
  {
    if (eOperationItemProvider == null)
    {
      eOperationItemProvider = new EOperationItemProvider(this);
    }

    return eOperationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EPackage} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EPackageItemProvider ePackageItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EPackage}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEPackageAdapter()
  {
    if (ePackageItemProvider == null)
    {
      ePackageItemProvider = new EPackageItemProvider(this);
    }

    return ePackageItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EParameter} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EParameterItemProvider eParameterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EParameter}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEParameterAdapter()
  {
    if (eParameterItemProvider == null)
    {
      eParameterItemProvider = new EParameterItemProvider(this);
    }

    return eParameterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EReference} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EReferenceItemProvider eReferenceItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EReference}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEReferenceAdapter()
  {
    if (eReferenceItemProvider == null)
    {
      eReferenceItemProvider = new EReferenceItemProvider(this);
    }

    return eReferenceItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EStringToStringMapEntryItemProvider eStringToStringMapEntryItemProvider;

  /**
   * This creates an adapter for a {@link java.util.Map.Entry}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEStringToStringMapEntryAdapter()
  {
    if (eStringToStringMapEntryItemProvider == null)
    {
      eStringToStringMapEntryItemProvider = new EStringToStringMapEntryItemProvider(this);
    }

    return eStringToStringMapEntryItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.EGenericType} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EGenericTypeItemProvider eGenericTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.EGenericType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEGenericTypeAdapter()
  {
    if (eGenericTypeItemProvider == null)
    {
      eGenericTypeItemProvider = new EGenericTypeItemProvider(this);
    }

    return eGenericTypeItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.ecore.ETypeParameter} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ETypeParameterItemProvider eTypeParameterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.ecore.ETypeParameter}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createETypeParameterAdapter()
  {
    if (eTypeParameterItemProvider == null)
    {
      eTypeParameterItemProvider = new ETypeParameterItemProvider(this);
    }

    return eTypeParameterItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ComposeableAdapterFactory getRootAdapterFactory()
  {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
  {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  @Override
  public boolean isFactoryForType(Object type)
  {
    return supportedTypes.contains(type) || type == modelPackage;
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type)
  {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type)
  {
    if (isFactoryForType(type))
    {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class) || (((Class<?>)type).isInstance(adapter)))
      {
        return adapter;
      }
    }

    return null;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void addListener(INotifyChangedListener notifyChangedListener)
  {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void removeListener(INotifyChangedListener notifyChangedListener)
  {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void fireNotifyChanged(Notification notification)
  {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null)
    {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory. 
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void dispose()
  {
    if (eAttributeItemProvider != null) eAttributeItemProvider.dispose();
    if (eAnnotationItemProvider != null) eAnnotationItemProvider.dispose();
    if (eClassItemProvider != null) eClassItemProvider.dispose();
    if (eDataTypeItemProvider != null) eDataTypeItemProvider.dispose();
    if (eEnumItemProvider != null) eEnumItemProvider.dispose();
    if (eEnumLiteralItemProvider != null) eEnumLiteralItemProvider.dispose();
    if (eFactoryItemProvider != null) eFactoryItemProvider.dispose();
    if (eObjectItemProvider != null) eObjectItemProvider.dispose();
    if (eOperationItemProvider != null) eOperationItemProvider.dispose();
    if (ePackageItemProvider != null) ePackageItemProvider.dispose();
    if (eParameterItemProvider != null) eParameterItemProvider.dispose();
    if (eReferenceItemProvider != null) eReferenceItemProvider.dispose();
    if (eStringToStringMapEntryItemProvider != null) eStringToStringMapEntryItemProvider.dispose();
    if (eGenericTypeItemProvider != null) eGenericTypeItemProvider.dispose();
    if (eTypeParameterItemProvider != null) eTypeParameterItemProvider.dispose();
  }

}
