/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath;

import java.lang.reflect.Field;
import java.util.ArrayList;

public class XPathNode {
    public static final int TYPE_ROOTS_CONTAINER = -1;
    public static final int TYPE_NODE_REFERENCE = -2;
    public static final int TYPE_ROOT_EXPRESSION = -3;
    public static final int TYPE_PREDICATE_START = 0;
    public static final int TYPE_PREDICATE = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_LITERAL = 3;
    public static final int TYPE_ADDITIVE = 4;
    public static final int TYPE_MULTIPLICATIVE = 5;
    public static final int TYPE_UNARY = 6;
    public static final int TYPE_RELATIONAL = 7;
    public static final int TYPE_EQUALITY = 8;
    public static final int TYPE_ANDEXPR = 9;
    public static final int TYPE_OREXPR = 10;
    public static final int TYPE_BOOLEAN = 11;
    public static final int TYPE_VARIABLEREF = 12;
    public static final int TYPE_FUNCTION_CALL = 13;
    public static final int TYPE_NAME_TEST = 14;
    public static final int TYPE_AXIS_SPECIFIER = 15;
    public static final int TYPE_NODE_TYPE_TEST = 16;
    XPathNode ref;
    XPathNode parent;
    int type;
    int nodeLeafCount = 0;
    ArrayList children = new ArrayList();
    ArrayList args = new ArrayList();
    String hashcode = "";

    public XPathNode(int type) {
        this.type = type;
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public String getArg(int index) {
        return (String)this.args.get(index);
    }

    public int getArgCount() {
        return this.args.size();
    }

    public void addArg(Object arg) {
        this.args.add(String.valueOf(arg));
    }

    public void setArg(int index, String replacement) {
        this.args.set(index, replacement);
    }

    public void removeChild(XPathNode orig) {
        this.children.remove(orig);
    }

    public void replaceChild(XPathNode orig, XPathNode replacement) {
        int n = this.children.indexOf(orig);
        this.children.set(n, replacement);
    }

    public void insertChild(XPathNode node) {
        this.children.add(0, node);
        node.parent = this;
    }

    public void addChild(XPathNode node) {
        this.children.add(node);
        node.parent = this;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getType() {
        return this.type;
    }

    public XPathNode getChild(int index) {
        return (XPathNode)this.children.get(index);
    }

    public int getNodeLeafCount() {
        return this.nodeLeafCount;
    }

    public String getHashCode() {
        return this.hashcode;
    }

    public void recalculate() {
        StringBuffer hashcode = new StringBuffer();
        hashcode.append(":[TYP/" + this.type + "]:");
        int i = 0;
        while (i < this.args.size()) {
            hashcode.append(":[ARG/" + this.args.get(i) + "]:");
            ++i;
        }
        this.nodeLeafCount = this.args.size();
        i = 0;
        while (i < this.children.size()) {
            XPathNode child = (XPathNode)this.children.get(i);
            child.recalculate();
            hashcode.append(child.getHashCode());
            this.nodeLeafCount += 1 + child.getNodeLeafCount();
            ++i;
        }
        this.hashcode = String.valueOf(String.valueOf(999999 - this.nodeLeafCount)) + hashcode.toString();
    }

    public static String typeToString(int typ) {
        try {
            Field[] fields = XPathNode.class.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().startsWith("TYPE_") && fields[i].getInt(null) == typ) {
                    return fields[i].getName().substring(5);
                }
                ++i;
            }
        }
        catch (IllegalAccessException illegalAccessException) {}
        return "unknown type";
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append("  ");
            ++i;
        }
        sb.append(XPathNode.typeToString(this.type));
        sb.append(" ");
        i = 0;
        while (i < this.args.size()) {
            sb.append(this.args.get(i));
            sb.append(",");
            ++i;
        }
        sb.setLength(sb.length() - 1);
        i = 0;
        while (i < this.children.size()) {
            sb.append("\n");
            sb.append(((XPathNode)this.children.get(i)).toString(depth + 1));
            ++i;
        }
        if (this.type == -2) {
            sb.append("\n");
            sb.append(this.ref.toString(depth + 1));
        }
        return sb.toString();
    }

    public boolean equals(XPathNode node) {
        Object theirs;
        Object mine;
        if (this.type != node.type) {
            return false;
        }
        if (this.args.size() != node.args.size()) {
            return false;
        }
        int i = 0;
        while (i < this.args.size()) {
            mine = this.getArg(i);
            if (!((String)mine).equals(theirs = node.getArg(i))) {
                return false;
            }
            ++i;
        }
        if (this.children.size() != node.children.size()) {
            return false;
        }
        i = 0;
        while (i < this.children.size()) {
            mine = this.getChild(i);
            if (!((XPathNode)mine).equals((XPathNode)(theirs = node.getChild(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

