/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * This interface is used for representing instances of logical packages in
 * the workspace.  The actual workspace object is identified by the IFile
 * object associated with this object.
 * 
 * @author rcernich
 * 
 * Created on Mar 16, 2004
 */
public interface ILogicalPackage extends IPackage {

	/**
	 * Returns the actual technology version of this package.  Packaging
	 * extensions may provide support for a range of technology versions.  This
	 * is the version of this package.
	 * 
	 * @return the technology version of this package.
	 */
	ITechnologyType getTechnologyType();
	
	IRuntimeType getRuntimeType();

}
