/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Deploy Package</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl#getTargetConfiguration <em>Target Configuration</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl#getRoot <em>Root</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployPackageImpl#getPackageFile <em>Package File</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DeployPackageImpl extends EObjectImpl implements DeployPackage {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * The cached value of the '{@link #getTargetConfiguration() <em>Target Configuration</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetConfiguration()
	 * @generated
	 * @ordered
	 */
	protected EList targetConfiguration;

	/**
	 * The default value of the '{@link #getPackageFile() <em>Package File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackageFile()
	 * @generated
	 * @ordered
	 */
	protected static final String PACKAGE_FILE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPackageFile() <em>Package File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPackageFile()
	 * @generated
	 * @ordered
	 */
	protected String packageFile = PACKAGE_FILE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeployPackageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DeployFilePackage.Literals.DEPLOY_PACKAGE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTargetConfiguration() {
		if (targetConfiguration == null) {
			targetConfiguration = new EObjectContainmentWithInverseEList(
					DeployConfiguration.class, this,
					DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION,
					DeployFilePackage.DEPLOY_CONFIGURATION__SOURCE_PACKAGE);
		}
		return targetConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root getRoot() {
		if (eContainerFeatureID != DeployFilePackage.DEPLOY_PACKAGE__ROOT)
			return null;
		return (Root) eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRoot(Root newRoot, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newRoot,
				DeployFilePackage.DEPLOY_PACKAGE__ROOT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRoot(Root newRoot) {
		if (newRoot != eInternalContainer()
				|| (eContainerFeatureID != DeployFilePackage.DEPLOY_PACKAGE__ROOT && newRoot != null)) {
			if (EcoreUtil.isAncestor(this, newRoot))
				throw new IllegalArgumentException(
						"Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRoot != null)
				msgs = ((InternalEObject) newRoot).eInverseAdd(this,
						DeployFilePackage.ROOT__PACKAGE, Root.class, msgs);
			msgs = basicSetRoot(newRoot, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_PACKAGE__ROOT, newRoot, newRoot));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPackageFile() {
		return packageFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPackageFile(String newPackageFile) {
		String oldPackageFile = packageFile;
		packageFile = newPackageFile;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_PACKAGE__PACKAGE_FILE,
					oldPackageFile, packageFile));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION:
			return ((InternalEList) getTargetConfiguration()).basicAdd(
					otherEnd, msgs);
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetRoot((Root) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION:
			return ((InternalEList) getTargetConfiguration()).basicRemove(
					otherEnd, msgs);
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			return basicSetRoot(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			return eInternalContainer().eInverseRemove(this,
					DeployFilePackage.ROOT__PACKAGE, Root.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION:
			return getTargetConfiguration();
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			return getRoot();
		case DeployFilePackage.DEPLOY_PACKAGE__PACKAGE_FILE:
			return getPackageFile();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION:
			getTargetConfiguration().clear();
			getTargetConfiguration().addAll((Collection) newValue);
			return;
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			setRoot((Root) newValue);
			return;
		case DeployFilePackage.DEPLOY_PACKAGE__PACKAGE_FILE:
			setPackageFile((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION:
			getTargetConfiguration().clear();
			return;
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			setRoot((Root) null);
			return;
		case DeployFilePackage.DEPLOY_PACKAGE__PACKAGE_FILE:
			setPackageFile(PACKAGE_FILE_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_PACKAGE__TARGET_CONFIGURATION:
			return targetConfiguration != null
					&& !targetConfiguration.isEmpty();
		case DeployFilePackage.DEPLOY_PACKAGE__ROOT:
			return getRoot() != null;
		case DeployFilePackage.DEPLOY_PACKAGE__PACKAGE_FILE:
			return PACKAGE_FILE_EDEFAULT == null ? packageFile != null
					: !PACKAGE_FILE_EDEFAULT.equals(packageFile);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (packageFile: ");
		result.append(packageFile);
		result.append(')');
		return result.toString();
	}

} //DeployPackageImpl
