/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.api;

import org.eclipse.stp.b2j.core.publicapi.JARDependency;


/**
 * 
 * @author amiguel
 *
 * A class to create engine Programs from various sources, such as a set of pre compiled java Class files
 * or a set of BPEL, WSDL and XSD files
 */
public class JavaProgramFactory {

	public static Program createEngineProgramFromClassFiles(byte[] main_class, byte[][] extra_classes, JARDependency[] deps) {
		return new Program(main_class,extra_classes,deps);
	}		
}