/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * Johnson: we need to revisit this page to show the runtime information for the selected page later.
 * however, we won't allow user to change runtime from here
 * @author jma
 *
 */
public class ScJaxWsPropertyPage extends PropertyPage {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJaxWsPropertyPage.class);

	private DirectoryFieldEditor editor = null;

	/**
	 * Constructor for JaxWSPropertyPage.
	 */
	public ScJaxWsPropertyPage() {
		super();
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData data = new GridData(GridData.FILL);
		data.grabExcessHorizontalSpace = true;
		composite.setLayoutData(data);
		addRuntimeInfo(composite);
		return composite;
	}
	
	private void addRuntimeInfo(Composite parent) {
		
		Group grpRuntime = new Group(parent, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        grpRuntime.setLayout(gridLayout);
        GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    gridData.grabExcessHorizontalSpace = true;
	    grpRuntime.setLayoutData(gridData);
	    
        Label runtimeLbl = new Label(grpRuntime, SWT.NONE);
        runtimeLbl.setText(ScJaxWsResources.getString("project.propertypage.runtime"));
        
        //get the runtime info
        IProject project = (IProject)getElement();
        String runtimeId = RuntimeCore.getRuntimeID(project);
        Text runtimeTxt = new Text(grpRuntime, SWT.SINGLE | SWT.BORDER);
        runtimeTxt.setText(runtimeId);
        runtimeTxt.setEditable(false);
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        runtimeTxt.setLayoutData(gridData);
	}

//	private void addRuntimeProviderInfo(Composite comp) {
//		String edLabel = ScJaxWsResources.getString("Project.Runtime.Property.Name");
//		editor = new DirectoryFieldEditor("", edLabel, comp);
//		String installDir = null;
//		try {
//			installDir = ((IResource) getElement()).getPersistentProperty(
//				ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT);
//		} catch (CoreException e) {
//			LOG.debug("Error setting initial value to installation field");
//		}
//		editor.setStringValue((installDir != null) ? installDir : "");
//	}

	protected void performDefaults() {
		/*
		IRuntimeKitProcessor rtProcessor = RuntimeProviderManager.getInstance().getRuntimeKitProcessor((IProject)getElement());
		IPath kitPath = rtProcessor.getInstallationDirectory();
		editor.setStringValue(kitPath.toOSString());
		*/
	}
	
	public boolean performOk() {
		/*
		String oldValue = null;
		IRuntimeKitProcessor rtp = null;
		IJavaProject jProject = null;
		// store the value in the owner text field
		try {
			oldValue = ((IResource) getElement()).getPersistentProperty( 
							ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT);
			if (oldValue != null) {
				rtp = ScJaxWsPlugin.getRuntimeProviderManager().getRuntimeKitProcessor((IProject)getElement());
				jProject = JavaCore.create((IProject)getElement());
				rtp.clearJavaProjectBuildPath(jProject);
			}
			
			((IResource) getElement()).setPersistentProperty(
				ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT,
				editor.getStringValue());
		} catch (CoreException e) {
			return false;
		}
		try {
			rtp.completeJavaProjectBuildPath(jProject);
		} catch (JavaModelException e) {
			LOG.debug("Failed to update project build path", e);
		} catch (CoreException e) {
			LOG.debug("Failed to update project build path", e);
		}
		*/
		
		return true;
	}

}