/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.edit.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ChangeSCAObjectNameOperation extends AbstractScribblerOperation {
   private String oldName = null;

   private String newName = null;

   public ChangeSCAObjectNameOperation() {
      super();
   }

   public ChangeSCAObjectNameOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {
      SCAObject scaObject = (SCAObject) model
            .getProperty(IChangeSCAObjectNameDataModelProperties.SCAOBJECT);
      Assert.isNotNull(scaObject);

      oldName = scaObject.getName();
      newName = model
            .getStringProperty(IChangeSCAObjectNameDataModelProperties.NEW_NAME);

      if (!newName.equals(oldName))
         scaObject.setName(newName);

      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      SCAObject scaObject = (SCAObject) model
            .getProperty(IChangeSCAObjectNameDataModelProperties.SCAOBJECT);
      scaObject.setName(newName);
      return OK_STATUS;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      SCAObject scaObject = (SCAObject) model
            .getProperty(IChangeSCAObjectNameDataModelProperties.SCAOBJECT);
      scaObject.setName(oldName);
      return OK_STATUS;
   }
}
