package org.eclipse.stp.sc.sca.java.wizards;

import java.util.Hashtable;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public class ScaRMIBindingWizardPage extends ScaBindingPage {

	ScaJavaProjectWizard scaWizard;
	ScaRMIBindingPageComposite composite;
	
	protected ScaRMIBindingWizardPage(String pageName, ScaJavaProjectWizard wizard) {
		super(pageName);
		setTitle(ScaJavaResources.getString("wizard.project.generalpage.title"));
		setDescription("Set RMI binding information");
		ImageDescriptor banner = ScaJavaResources.getImageDescriptor("wizban/sca_wiz.gif");
        setImageDescriptor(banner);
		scaWizard = wizard;
	}
	
	public void createControl(Composite parent) {
		composite = new ScaRMIBindingPageComposite(parent, 
				SWT.NULL);
		this.setControl(composite);
		composite.txtHost.setText("localhost");
		composite.txtPort.setText("1099");
		composite.txtHost.addModifyListener(new TextModifyAdapter());
		composite.txtPort.addModifyListener(new TextModifyAdapter());
		composite.txtServiceName.addModifyListener(new TextModifyAdapter());
		composite.txtHost.setFocus();
	}
	
	public void setVisible(boolean visible) {
        super.setVisible(visible);
        String scaServiceName = scaWizard.compPage.composite.txtInterface.getText();
		scaServiceName += "RemoteService";
		composite.txtServiceName.setText(scaServiceName);
		
    }

	private boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (composite.txtHost.getText() == null
				|| composite.txtHost.getText().equals("")) {
			setErrorMessage("Host name can't be empty");
			return false;
		}
		if (composite.txtPort.getText() == null
				|| composite.txtPort.getText().equals("")) {
			setErrorMessage("port can't be empty");
			return false;
		}
		if (composite.txtServiceName.getText() == null
				|| composite.txtServiceName.getText().equals("")) {
			setErrorMessage("Service name can't be empty");
			return false;
		}
        return true;
	}
	
	protected Hashtable<String, String> getBindingAttrs() {
		Hashtable<String, String> attrs = new Hashtable<String, String>();
        attrs.put("host", composite.txtHost.getText());
        attrs.put("port", composite.txtPort.getText());
        attrs.put("serviceName", composite.txtServiceName.getText());
        return attrs;
	}
	
	class TextModifyAdapter implements ModifyListener {
		public void modifyText(ModifyEvent e) {
			setPageComplete(validatePage());
		}
	}
}
