/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;


import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.xef.XMLInstanceElement;

public class MasterContentProvider implements ITreeContentProvider {        
    @SuppressWarnings("unchecked")
    public Object[] getElements(Object inputElement) {
        List<XMLInstanceElement> policies = (List<XMLInstanceElement>) inputElement;
        
        // Use a LinkedHashMap to make sure the policies appear in the right order.
        Map<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (XMLInstanceElement policy : policies) {
            String snippet = policy.getBasedOnSnippet(); 
            if (snippet != null) {
                SnippetRepresentingXMLInstanceElements wxie = (SnippetRepresentingXMLInstanceElements) result.get(snippet);
                if (wxie == null) {
                    wxie = new SnippetRepresentingXMLInstanceElements();
                    result.put(snippet, wxie);
                }                    
                wxie.addPolicy(policy);
                policy.setData(SnippetRepresentingXMLInstanceElements.class, wxie);
            } else {
                result.put(policy, policy);
            }
        }
        return result.values().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof XMLInstanceElement) {
            return ((XMLInstanceElement) parentElement).getChildren().toArray();
        } else if (parentElement instanceof SnippetRepresentingXMLInstanceElements) {
            return ((SnippetRepresentingXMLInstanceElements) parentElement).getElements().toArray();
        } else {
            return null;
        }
    }

    public Object getParent(Object element) {
        if (element instanceof XMLInstanceElement) {
            return ((XMLInstanceElement) element).getParent();
        }
        return null; 
    }

    public boolean hasChildren(Object element) {
        if (element instanceof XMLInstanceElement) {
            return ((XMLInstanceElement) element).getChildren().size() > 0;
        } else if (element instanceof SnippetRepresentingXMLInstanceElements) {
            return ((SnippetRepresentingXMLInstanceElements) element).getElements().size() > 0;
        } else {
            return false;
        }
    }        

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}
