package org.eclipse.stp.sc.cxf.kitprocessor;

import java.util.ArrayList;
import java.util.List;

import org.eclipes.stp.soas.deploy.runtime.cxf.core.internal.ICxfRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.wst.server.core.IRuntime;

public class CxfRuntimeKitProcessor implements IRuntimeKitProcessor {

//	private static final String CELTIX_KIT_HOME_VAR_NAME = "CXF_HOME";
	
	public void clearJavaProjectBuildPath(IJavaProject project)
			throws JavaModelException, CoreException {
        
        IPath runtimePath = RuntimeCore.getInstallPath(project.getProject());
        String varName = runtimePath.toOSString();
        if(varName == null){
        	return;
        }
        WorkspaceManager.removeEntriesFromClassPath(project, varName);
	}

	public void completeJavaProjectBuildPath(IJavaProject project)
			throws JavaModelException, CoreException {
        IRuntime runtime = RuntimeCore.getRuntime(project.getProject());
        ICxfRuntime cxfRuntime = (ICxfRuntime)runtime.loadAdapter(ICxfRuntime.class, null);
//        ICxfRuntime cxfRuntimeICxfRuntime cxfRuntime = (ICxfRuntime)runtime;
        List<IRuntimeClasspathEntry> libs = cxfRuntime.getRuntimeClasspath();
        ArrayList<IClasspathEntry> clsLibs = new ArrayList<IClasspathEntry>();
        for (IRuntimeClasspathEntry runtimeEntry : libs) {
        	clsLibs.add(runtimeEntry.getClasspathEntry());
        }
        WorkspaceManager.addEntriesToClassPath(project, clsLibs); 
	}

//	public List<IPath> getDefaultBuildPathEntries(IProject project) {
//		Exception e = new Exception ();
//		e.printStackTrace();
//		return null;
//	}

//	public String getDefaultSubstitutionVarName() {
//		return CELTIX_KIT_HOME_VAR_NAME;
//	}
//
//	public String getSubstitutionVarName() {
//        return CELTIX_KIT_HOME_VAR_NAME;
//	}

}
