/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.multiplex;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class ByteArrayInBuffer
extends InputStream {
    public static final int INFINITE_BUFFER = -1;
    public static final int DEFAULT_BUFFER = 400000;
    Object buffer_LOCK = new Object();
    LinkedList bufs = new LinkedList();
    int len = 0;
    byte[] buffer = new byte[0];
    int ptr = 0;
    boolean closed = false;
    IOException ioexception = null;
    boolean waiting_for_data = false;
    boolean waiting_for_space = false;
    int max_buffer = 400000;

    public ByteArrayInBuffer() {
    }

    public ByteArrayInBuffer(int max_buffer) {
        this.max_buffer = max_buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            return this.len + (this.buffer.length - this.ptr);
        }
    }

    private void waitForData() {
        while (this.len <= 0 && !this.closed) {
            try {
                this.waiting_for_data = true;
                this.buffer_LOCK.wait();
                this.waiting_for_data = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed() {
        this.closed = true;
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.waiting_for_data) {
                this.buffer_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(IOException t) {
        this.closed = true;
        this.ioexception = t;
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.waiting_for_data) {
                this.buffer_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            block8: {
                block7: {
                    if (!this.closed || this.len != 0) break block7;
                    if (this.ioexception != null) {
                        throw this.ioexception;
                    }
                    return -1;
                }
                this.get();
                if (!this.closed || this.len != 0) break block8;
                if (this.ioexception != null) {
                    throw this.ioexception;
                }
                return -1;
            }
            return 0xFF & this.buffer[this.ptr++];
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int length) throws IOException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            block9: {
                block8: {
                    if (!this.closed || this.len != 0) break block8;
                    if (this.ioexception != null) {
                        throw this.ioexception;
                    }
                    return -1;
                }
                this.get();
                if (!this.closed || this.len != 0) break block9;
                if (this.ioexception != null) {
                    throw this.ioexception;
                }
                return -1;
            }
            int tmplen = this.buffer.length - this.ptr;
            if (tmplen <= length) {
                System.arraycopy(this.buffer, this.ptr, b, off, tmplen);
                this.ptr += tmplen;
                return tmplen;
            }
            System.arraycopy(this.buffer, this.ptr, b, off, length);
            this.ptr += length;
            return length;
        }
    }

    private void get() {
        if (this.ptr >= this.buffer.length) {
            this.waitForData();
            if (!this.closed) {
                this.buffer = (byte[])this.bufs.removeFirst();
                this.len -= this.buffer.length;
                this.ptr = 0;
            }
            if (this.waiting_for_space) {
                this.buffer_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] dat) {
        if (dat.length > 0) {
            Object object = this.buffer_LOCK;
            synchronized (object) {
                while (dat.length + this.len + (this.buffer.length - this.ptr) > this.max_buffer && this.len > 0 && this.max_buffer >= 0) {
                    this.waiting_for_space = true;
                    try {
                        this.buffer_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    this.waiting_for_space = false;
                }
                this.bufs.addLast(dat);
                this.len += dat.length;
                if (this.waiting_for_data) {
                    this.buffer_LOCK.notify();
                }
            }
        }
    }
}

