/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * This class represents an HTTP header.
 * 
 * This class is currently unused
 * 
 * @author amiguel
 *
 */
public class HTTPHeader {
	
	String request_type;
	String resource;
	String http_version;
	
	ArrayList headers_name_list = new ArrayList();
	ArrayList headers_value_list = new ArrayList();
	HashMap lc_headers_map = new HashMap();
	
	public HTTPHeader() {
	}
	
	public void clear() {
		request_type = null;
		resource = null;
		http_version = null;
		
		headers_name_list.clear();
		headers_value_list.clear();
		lc_headers_map.clear();
	}
	
	public void setRequestType(String type) throws IOException {
		request_type = type;
	}

	public void setResource(String res) throws IOException {
		resource = res;
	}

	public void setHttpVersion(String ver) throws IOException {
		http_version = ver;
	}
	
	public void addHeader(String name, String value) throws IOException {
		headers_name_list.add(name);
		headers_value_list.add(value);
		lc_headers_map.put(name.toLowerCase(),value);
	}
}