/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.core.introspection.IShareableComponentTypeFactory;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Component</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.Component#getPropertyValuesSet <em>Property Values Set</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Component#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getComponent()
 * @model abstract="true" features="referenceValuesSet"
 *        referenceValuesSetType="org.eclipse.stp.core.sca.ReferenceValuesSet"
 *        referenceValuesSetOpposite="component"
 *        referenceValuesSetContainment="true"
 *        referenceValuesSetResolveProxies="false"
 *        referenceValuesSetSuppressedGetVisibility="true"
 *        referenceValuesSetSuppressedSetVisibility="true"
 *        referenceValuesSetExtendedMetaData="kind='element' name='references'"
 *        extendedMetaData="name='Component' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface Component extends SCAObject {

   /**
    * The type string for the abstract type ("implementation.abstract").
    */
   public static final String TYPE_ABSTRACT     = "implementation.abstract";                                                                            //$NON-NLS-1$

   /**
    * Indicates the Abstract state. An Abstract component either has no
    * implementation or an {@link AbstractImplementation}.
    * 
    * @see AbstractImplementation
    * @see SCAPackage#getAbstractImplementation()
    */
   public static final int    STATE_ABSTRACT    = 1;

   /**
    * Indicates the Typed state. A Typed component has an
    * {@link AbstractImplementation} with the type set
    * {@link AbstractImplementation#getType()}.
    * 
    * @see AbstractImplementation
    * @see AbstractImplementation#setType(String)
    * @see AbstractImplementation#getType()
    */
   public static final int    STATE_TYPED       = 2;

   /**
    * Indicates the Implemented state. An Implemented component has a
    * specialized Implementation set.
    */
   public static final int    STATE_IMPLEMENTED = 3;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String                     copyright         = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$ 

   /**
    * Returns the value of the '<em><b>Property Values Set</b></em>'
    * containment reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Property Values Set</em>' containment
    * reference isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Property Values Set</em>' containment
    *         reference.
    * @see #setPropertyValuesSet(PropertyValuesSet)
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponent_PropertyValuesSet()
    * @model containment="true" resolveProxies="false"
    *        extendedMetaData="kind='element' name='properties'"
    * @generated
    */
   PropertyValuesSet getPropertyValuesSet();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Component#getPropertyValuesSet <em>Property Values Set</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Property Values Set</em>'
    *           containment reference.
    * @see #getPropertyValuesSet()
    * @generated
    */
   void setPropertyValuesSet(PropertyValuesSet value);

   /**
    * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Name</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Name</em>' attribute.
    * @see #setName(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getComponent_Name()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        required="true" extendedMetaData="kind='attribute' name='name'"
    * @generated
    */
   String getName();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Component#getName <em>Name</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Name</em>' attribute.
    * @see #getName()
    * @generated
    */
   void setName(String value);

   /**
    * Uses the Implementation to resolve the ComponentType.
    * 
    * <p>
    * If the Implementation is abstract, then the ComponentType is an embedded
    * element and cannot be shared. Otherwise, the ComponentType could be
    * shared; the underlying implementation will determine if the ComponentType
    * can be shared and handle it automatically.
    * </p>
    * 
    * <p>
    * The ComponentType can be shared in some cases. If the implementation
    * introspector defines an {@link IShareableComponentTypeFactory}, then the
    * implementation model will be converted to URI and requested through the
    * ResourceSet of the Implementation that is supplied.
    * </p>
    * <p>
    * Therefore, resolve() should only be supplied implementations that are
    * contained by a Component, which are contained by a ResourceSet. (The
    * actual containment is Implementation > Component > Composite/Module >
    * SCACoreRoot > Resource > ResourceSet).
    * </p>
    * <p>
    * The one special case is AbstractImplementation ({@link org.eclipse.stp.core.sca.SCAPackage#getAbstractImplementation()})
    * which does not need to be contained to be resolved.
    * </p>
    * <p>
    * The feature from the implementation will be determined using the
    * FeatureMap of the containing {@link org.eclipse.stp.core.sca.Component}.
    * </p>
    * 
    * <p>
    * The containment requirement is to allow context for resolving a
    * specialized implementation. For cases where the Component or the
    * Implementation is not contained, use
    * {@link org.eclipse.stp.core.introspection.IModelIntrospectionManager#resolve(Implementation)}
    * to resolve an Implementation and explicitly supply the correct project as
    * the context.
    * </p>
    * 
    * @return The ComponentType contract for this Component
    */
   ComponentType resolveComponentType();

   /**
    * @return One of {@link #STATE_ABSTRACT}, {@link #STATE_TYPED}, or
    *         {@link #STATE_IMPLEMENTED}.
    */
   int getState();

   /**
    * 
    * @return The type of the underlying implementation. When
    *         {@link #getState()} returns {@link #STATE_ABSTRACT}, the type
    *         will be "implementation.abstract". Otherwise, the type will be the
    *         substitution group name of the implementation.
    */
   String getType();

   /**
    * To correctly support substitution groups, the specific EMF feature for an
    * implementation element type must be specified through a
    * {@link org.eclipse.stp.core.introspection.FeatureAdapter} attached to the
    * Implementation. Component Handlers or other clients should set the feature
    * using
    * {@link org.eclipse.stp.core.introspection.FeatureAdapter#setFeature(SCAObject, EStructuralFeature)}.
    * For the example test, a PropertiesImplementation was created which has a
    * structural feature on the document root of
    * PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties(). So the
    * correct feature to set using the FeatureAdapter for the
    * PropertiesImplementation EClass instances is
    * PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties(). This
    * will ensure that when the XML document is serialized, that it uses the
    * substitution group element name ("implementation.properties") instead of
    * using the xsi:type="props:PropertiesImplementation" format.
    * 
    * 
    * @param newImplementation
    *           The instance of the implementation to configure this component
    *           with.
    * @return The existing Implementation.
    */
   Implementation setSpecializedImplementation(Implementation newImplementation);

   /**
    * A convenience method to set an abstract implementation type
    * (SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract()). The
    * serialized form will have the element name "implemenation.abstract" with a
    * serialized, embedded ComponentType (<componentType > ...</componentType>).
    * 
    * @param aComponentType
    *           The component type that should be used to configure the Abstract
    *           Implementation that will be created for this Component.
    * @return The existing Implementation.
    */
   Implementation setAbstractImplementation(ComponentType aComponentType);

   /**
    * The Implementation is a substitution group element that will be
    * specialized for each component type.
    * 
    * @return The current implementation set on this Component.
    */
   Implementation getImplementation();

   /**
    * @return the {@link Composite} which owns this Component.
    */
   Composite getComposite();

   /**
    * Create a new {@link ReferenceValue} that uses the reference as the source
    * and the passed target to configure the target value.
    * 
    * @param reference
    *           The reference from this Configurable's type representation.
    * @param target
    *           The endpoint that the reference should resolve to
    * 
    * @see ReferenceValue
    * @see WireSource#createWireToTarget(WireTarget)
    */
   void setReferenceValue(Reference reference, WireTarget target);

   /**
    * @return The list of {@link ReferenceValue} objects for this component.
    */
   List getReferenceValues();

   /**
    * @return An unmodifiable list of {@link ReferenceValue} elements for the
    *         passed reference. The list will contain at most one entry if the
    *         multiplicity of the passed reference is one.
    * @param reference
    */
   List getReferenceValues(Reference reference);

   /**
    * @return An unmodifiable list of {@link ReferenceValue} elements for the
    *         passed referenceName. The list will contain at most one entry if
    *         the multiplicity of the passed reference is one.
    * @param referenceName
    */
   List getReferenceValues(String referenceName);

   /**
    * @return A {@link WireTarget} only if there is one service available on
    *         this Component.
    */
   WireTarget getSingleWireTarget();

   /**
    * @param serviceName
    *           The name of the service on this Configurable's abstract type
    * @return A {@link WireTarget} for the passed serviceName. The serviceName
    *         must match the name of a service defined on the
    *         {@link ComponentType} otherwise null will be returned.
    */
   WireTarget getWireTarget(String serviceName);

   /**
    * @param service
    *           The Service on this Configurable's abstract type
    * @return A {@link WireTarget} for the passed service. The service must be a
    *         matching service defined on the {@link ComponentType} otherwise
    *         null will be returned.
    * 
    */
   WireTarget getWireTarget(Service service);

   /**
    * @param referenceName
    * @return A {@link WireSource} for the passed referenceName. The
    *         referenceName must match the name of a reference defined on the
    *         {@link ComponentType} otherwise null will be returned.
    */
   WireSource getWireSource(String referenceName);

   /**
    * @param reference
    * @return A {@link WireSource} for the passed reference. The reference must
    *         be a matching reference defined on the {@link ComponentType}
    *         otherwise null will be returned.
    */
   WireSource getWireSource(Reference reference);

   /**
    * @return A {@link WireSource} only if there is one reference available on
    *         this Component.
    */
   WireSource getSingleWireSource();

   /**
    * Return a collection of WireSource elements that have a wire to the passed
    * wireTarget.
    * 
    * @param wireTarget
    * @return Collection
    */
   Collection getWireSourcesWiredToTarget(WireTarget wireTarget);

} // Component
