/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.core.internal.saf.impl.SAFManagerUtils;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/**
 *
 */
public class BindingDeletionOperation extends AbstractDataModelOperation {	
	
	private List oldBindings = null;
	private SCAObject object = null;
	
	/**
	 * @param operationDataModel
	 */
	public BindingDeletionOperation(IDataModel operationDataModel) {
		super(operationDataModel);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.operations.IUndoableOperation#redo(org.eclipse.core.runtime.IProgressMonitor, org.eclipse.core.runtime.IAdaptable)
	 */
	public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		return Status.OK_STATUS;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.operations.IUndoableOperation#undo(org.eclipse.core.runtime.IProgressMonitor, org.eclipse.core.runtime.IAdaptable)
	 */
	public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {

		List bindings = null;
		if(object instanceof ExternalService)
			bindings = ((ExternalService)object).getBindings();
		else
			bindings = ((EntryPoint)object).getBindings();

		bindings.addAll(oldBindings);
		
		return Status.OK_STATUS;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.operations.IUndoableOperation#execute(org.eclipse.core.runtime.IProgressMonitor, org.eclipse.core.runtime.IAdaptable)
	 */
	public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		IStatus retStatus = OK_STATUS; 
		
		object = (SCAObject) model.getProperty(IBindingDeletionDataModelProperties.SCAOBJECT);
		boolean removeAll = model.getBooleanProperty(IBindingDeletionDataModelProperties.REMOVE_ALL);
		String type = model.getStringProperty(IBindingDeletionDataModelProperties.BINDING_TYPE);
		
		oldBindings = new ArrayList();
		List bindings = null;
		if(object instanceof ExternalService)
			bindings = ((ExternalService)object).getBindings();
		else
			bindings = ((EntryPoint)object).getBindings();

		if(removeAll){
			oldBindings.addAll(bindings);
			bindings.clear();
		}else{
			for (Iterator iter = bindings.iterator(); iter.hasNext();) {
				Binding b = (Binding) iter.next();
				if(SAFManagerUtils.getSubstitutionGroupName(b).equals(type))
					 oldBindings.add(b);
			}
			
			bindings.removeAll(oldBindings);
		}
						
		return retStatus;
	}

	public boolean canRedo() {
		return false;
	}
}
