/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/**
 * @author jma
 *
 */
public class WsdlGenPage extends WizardPage {


	/**
	 * the current runtime type that this page is generated
	 * is it is changed. we need to redraw the control
	 */
	private String runtimeType = null;
    
    protected IParameterPage paramPage;
    protected WsdlGenPage(String pageName) {
        super(pageName);
        setTitle(ScJaxWsResources.getString("WsdlGenPage.Title"));
	    setDescription(ScJaxWsResources.getString("WsdlGenPage.Description"));
	    ImageDescriptor banner = ScJaxWsResources.getImageDescriptor("wizban/jaxws_project_folder_wiz.jpg");
	    setImageDescriptor(banner);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(GridData.FILL_BOTH);
		this.setControl(composite);
    }
    
    /**
     * update the page control according to runtime selection.
     * dispose previous page control
     */
    public void updateControl(String newRuntimeType) {
    	
    	if (runtimeType != null) {
    	    if (newRuntimeType.equals(runtimeType)) {
    	    	return;
    	    }
    	}
    	runtimeType = newRuntimeType;
    	
    	Control curComposite = this.getControl();
        
    	Composite parent = this.getControl().getParent();
    	Control pageCtl = createParameterPage(parent); 
    	this.setControl(pageCtl);
    	parent.layout();
    	curComposite.dispose();
    	
    }
    
    protected Composite createParameterPage(Composite parent) {
    	Group grpParams = new Group(parent, SWT.NONE);
        grpParams.setLayoutData(new GridData(GridData.FILL_BOTH));
        grpParams.setLayout(new GridLayout(1, false));
        grpParams.setText(ScJaxWsResources.getString("Wsdl.To.Java.Gen.Param.Title"));
        
        RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
        
        paramPage = rtMgr.getParameterPage(runtimeType);
        paramPage.createContents(grpParams);
        paramPage.setPage(this);
        paramPage.validateParams();
        return grpParams;
    }
    
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
        	WsdlFirstProjectWizard wizard = (WsdlFirstProjectWizard)this.getWizard();
            paramPage.setWsdlUrl(wizard.getWsdlURL());
        }
    }
    
    

}
