/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.jws.HandlerChain;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.validator.XMLUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class NewHandlerCreationWizard extends BasicNewResourceWizard{
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
	
	static final String HANDLER_CHAINS_TAG = "handler-chains";
	static final String HANDLER_CHAIN_TAG = "handler-chain";
	static final String HANDLER_TAG = "handler";
	static final String HANDLER_NAME_TAG = "handler-name";
	static final String HANDLER_CLASS_TAG = "handler-class";
	static final String HANDLER_DEFAULT_NAMESPACE = "http://java.sun.com/xml/ns/javaee";

	private IWorkbench fWorkbench;
	private IStructuredSelection fSelection;

	NewHandlerWizardPage mainPage = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		fWorkbench= workbench;
		fSelection= currentSelection;
		super.init(workbench, currentSelection);
	}
	
	public void addPages(){
		super.addPages();
		mainPage = new NewHandlerWizardPage();
		mainPage.init(fSelection);
		addPage(mainPage);
		this.setWindowTitle(
				ScJaxWsResources.getString(
						"JaxwsHandler.NewHandlerCreationWizard.Title"));
	}
	
	public boolean performFinish() {
		if(mainPage != null){
			//create handler class
			mainPage.createHandlerClass(new NullProgressMonitor());
			
			//open the new handler class in editor
			IResource resource= mainPage.getModifiedResource();
			if (resource != null) {
				selectAndReveal((IFile) resource);
				openResource((IFile) resource);
			}	
			
			IFile handlerChainFile = null;
			IFile serviceFile = null;
			
			//generate handler configurations
			if(mainPage.getIsAddedToChain()){
				//add new handler to chain
				String filePath = mainPage.getHandlerChainFilePathAbsolute();
				if(filePath != null && filePath.length() > 0){
					File file = new File(filePath);
					addHandlerToChainFile(file, 
							mainPage.getTypeName().trim(),
							mainPage.getPackageText().trim() + "." + mainPage.getTypeName().trim());

					//refresh this new/modified handler chain file
					try{
						handlerChainFile = mainPage.getFileFromPath(filePath);
						if(handlerChainFile != null){
							handlerChainFile.refreshLocal(IResource.DEPTH_ONE, null);
						}
					}catch(Exception e){
						LOG.error(e.getMessage(), e);
					}					
				}
				
				//associate the handler chain with web service
				if(mainPage.getIsAssociated()){
					serviceFile = mainPage.getFileFromPath(mainPage.getServiceClassFilePath());
					if(serviceFile != null){
						ICompilationUnit cu = JDTUtils.getJavaUnitFromFile(serviceFile);
						IType targetMember = cu.findPrimaryType();
						if(targetMember != null){
							//get relative path of handler chain file to service file
							String relativePath = mainPage.getHandlerChainFilePathAbsolute();
							if(handlerChainFile != null){
								relativePath = getRelativePath(handlerChainFile.getFullPath(), serviceFile.getFullPath());
								if(relativePath == null){
									relativePath = handlerChainFile.getLocation().toString();
								}
							}
							
							//add @HandlerChain annotation
							CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(targetMember);
							ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
					        MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "file", relativePath);
					        annotValues.add(valPair);
							Annotation node = JDTUtils.newNormalAnnotation(
									astRoot, 
									HandlerChain.class.getSimpleName(), 
									annotValues);
							if(node != null){
								try{
									ScJDTUtils.addAnnotationToCu(cu, astRoot, node, targetMember, null);
									cu.save(null, true);
								}catch(Exception e){
									LOG.error(e.getMessage(), e);
								}
								
							}
						}
					}
				}
			}

		}
		return true;
	}
	
	private void openResource(final IFile resource) {
		final IWorkbenchPage activePage= PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		if (activePage != null) {
			final Display display= getShell().getDisplay();
			if (display != null) {
				display.asyncExec(new Runnable() {
					public void run() {
						try {
							IDE.openEditor(activePage, resource, true);
						} catch (PartInitException e) {
							LOG.error(e);
						}
					}
				});
			}
		}
	}
	
	private void addHandlerToChainFile(File file, String handlerName, String handlerClass){
		DocumentBuilder db = null;
		Document doc = null;
		DocumentBuilderFactory.newInstance().setAttribute("", null);
		try{
			if(file != null)
				db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				if(!file.exists()){
					boolean isCreated = false;
					try{
						if(!file.getParentFile().exists()){
							file.getParentFile().mkdirs();	
						}
							isCreated = file.createNewFile();
					}catch (IOException e){
						LOG.error(e.getMessage(), e);
						isCreated = false;
					}
					if(!isCreated){
						LOG.error("Cannot create this file: " + file.toString());
						return;
					}
					doc = db.newDocument();
					Element rootElement = doc.createElementNS(HANDLER_DEFAULT_NAMESPACE, HANDLER_CHAINS_TAG);
					addHandlerToRootElement(doc, rootElement, handlerName, handlerClass);
					doc.appendChild(rootElement);
				}else{
					doc = db.parse(file);
					Element rootElement = doc.getDocumentElement();
					addHandlerToRootElement(doc, rootElement, handlerName, handlerClass);
				}
				
				XMLUtils.saveDocument(doc, file.getAbsolutePath());
		
		}catch (Exception e){
			LOG.error(e);
		}

	}
	
	private void addHandlerToRootElement(Document doc, Element root, String handlerName, String handlerClass){
		if(doc != null && root != null){
			Element chain = doc.createElement(HANDLER_CHAIN_TAG);
			Element handler = doc.createElement(HANDLER_TAG);
			Text txtName = doc.createTextNode(handlerName);
			Text txtClass = doc.createTextNode(handlerClass);
			Element handlerNameEle = doc.createElement(HANDLER_NAME_TAG);
			Element handlerClassEle = doc.createElement(HANDLER_CLASS_TAG);
			handlerNameEle.appendChild(txtName);
			handlerClassEle.appendChild(txtClass);
			handler.appendChild(handlerNameEle);
			handler.appendChild(handlerClassEle);
			chain.appendChild(handler);
			root.appendChild(chain);		
		}
	}
	
	private String getRelativePath(IPath arg0, IPath arg1){
		StringBuffer buf = new StringBuffer();
		if(arg0 != null && arg1 != null){
			int count = arg0.matchingFirstSegments(arg1);
			int setCount0 = arg0.segmentCount();
			int segCount1 = arg1.segmentCount();
			for(int i = 0; i < segCount1 - count; i++ ){
				buf.append("..");
				buf.append(File.separatorChar);
			}
			
			for(int i = 0; i < setCount0 - count - 1; i++){
				buf.append(arg0.segment(count + i));
				buf.append(File.separatorChar);
			}
			buf.append(arg0.segment(setCount0 - 1));
		}
		return buf.toString();
	}
}
