/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;


import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.swt.graphics.Image;

public class MasterLabelProvider extends LabelProvider {
    @Override
    public Image getImage(Object element) {
        if (element instanceof XMLInstanceElement) {
            XMLInstanceElement pie = (XMLInstanceElement) element;
            if (pie.getParent() == null) {
                if (XefEditMasterDetailsBlock.getAllowedChildren(pie).size() > 0) {
                    return getImage(XefPlugin.IMG_INSTANCE_PLUS);                        
                } else {
                    return getImage(XefPlugin.IMG_INSTANCE);
                }
            } else {
                if (XefEditMasterDetailsBlock.getAllowedChildren(pie).size() > 0) {
                    return getImage(XefPlugin.IMG_SUB_ELEMENT_PLUS);
                } else {
                    return getImage(XefPlugin.IMG_SUB_ELEMENT);
                }
            }
        } else if (element instanceof SnippetRepresentingXMLInstanceElements) {
            return getImage(XefPlugin.IMG_SNIPPET);
        }
        return null;
    }

    private Image getImage(String id) {
        return XefPlugin.getDefault().getImageRegistry().get(id);
    }

    @Override
    public String getText(Object element) {
	return XefEditMasterDetailsBlock.getLabel(element);
    }
}
