/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.stp.xef.XMLInstanceElement;

class SnippetRepresentingXMLInstanceElements {
    private final List<XMLInstanceElement> elements = new ArrayList<XMLInstanceElement>();

    public void addPolicy(XMLInstanceElement policy) {
        elements.add(policy);
    }

    List<XMLInstanceElement> getElements() {
        return elements;
    }

    @Override
    public String toString() {
        if (elements.size() > 0) {
            return elements.get(0).getBasedOnSnippet();
        } else {
            return super.toString();
        }
    }
}
