/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;


import java.io.IOException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;


public class XefEditor extends FormEditor {
    XefEditPage policyEditPage;
    XMLEditPage xmlEditPage;    
    
    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        
        if (input instanceof XMLProviderEditorInput) {
            setPartName(((XMLProviderEditorInput) input).getTitle());
        } 
    }

    @Override
    protected void addPages() {
        try {
            policyEditPage = new XefEditPage(this, "policy", "Policy");
            addPage(policyEditPage);
            
            xmlEditPage = new XMLEditPage(this, "xml", "XML");
            addPage(xmlEditPage, getEditorInput());            
        } catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            editorDirtyStateChanged();
        }
        
        if (isDirty()) {
            validateEdit(input);
        }
    }    
    
    void fireSaveNeeded() {
        editorDirtyStateChanged();
    }
    
    private void validateEdit(IEditorInput input) {
        System.out.println("Validate the change here...");        
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (!synchronizeModelAndText()) {
            return;
        }
        xmlEditPage.doSave(monitor);
        
        IEditorInput editorInput = getEditorInput();        
        // TODO davidb need to sort out all these exceptions
        if (editorInput instanceof XMLProviderEditorInput) {
            try {
                ((XMLProviderEditorInput) editorInput).propagate();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (CoreException e) {
                e.printStackTrace();
            }
        }
        
        policyEditPage.clearDirty();
        firePropertyChange(PROP_TITLE);                
    }

    // Will return false if the current input is inconsistent.
    private boolean synchronizeModelAndText() {
        if (getActivePageInstance() == policyEditPage) {
            if (isDirty()) {
                if (!policyEditPage.block.validate()) {
                    return false;
                }
                policyEditPage.getManagedForm().commit(true);
                xmlEditPage.syncFromModel();
            }
        }
        return true;
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

}
