/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;


import org.eclipse.stp.xef.util.InputStreamHelper;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class URLSchemaProvider implements ISchemaProvider {
    Map<String, String> schemas = new HashMap<String, String>();
    Map<String, String> snippets = new HashMap<String, String>();

    public URLSchemaProvider(URL[] urls) throws Exception {
        this(urls, new XMLSnippet [] {});
    }
        
    public URLSchemaProvider(URL[] urls, XMLSnippet [] snips) throws Exception {
        SAXBuilder builder = new SAXBuilder();

        for (URL url : urls) {
            InputStream is = url.openStream();
            try {
                String schema = new String(InputStreamHelper.drain(is));
                Document d = builder.build(new ByteArrayInputStream(schema.getBytes()));
                schemas.put(d.getRootElement().getNamespace("tns").getURI(), schema);
            } finally {
                is.close();
            }
        }
        
        for (XMLSnippet snip : snips) {
            snippets.put(snip.getName(), snip.getSnippet());
        }
    }

    public String getSchema(String ns) {
        return schemas.get(ns);
    }

    public String getSnippet(String name) {
        return snippets.get(name);
	}

	public Collection<String> listSchemaNamespaces(String filter) {
        return schemas.keySet();
    }

	public Collection<String> listSnippets(String filter) {
		return snippets.keySet();
	}

	public void refresh() {	}
}
