/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2005
 */
public class BaseAction extends BaseSelectionListenerAction {


	protected BaseAction(String text) {
		super(text); 
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection) {
		boolean retVal = super.updateSelection(selection);
		if (retVal) {
			setEnabled(selection.size() == 1
					&& selection.getFirstElement() instanceof Root);
		}
		return retVal && true;
	}

	protected Root getSelectedRoot() {
		return (Root) getStructuredSelection().getFirstElement();
	}
}
