package org.eclipse.stp.soas.deploy.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.WTPServiceModuleFactory;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class DeploymentUtil {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(DeploymentUtil.class);
	
	public static Version convertWTPVersion(String version){
		
		return null;
	}
	
	public static Map<IServerType, List<IServer>> getServerMap(){
		
		Map<IServerType, List<IServer>> mpServer = new HashMap<IServerType, List<IServer>>();
		IServer[] servers = ServerCore.getServers();
		for(int i = 0; i < servers.length; i++){
			IServerType serverType = servers[i].getServerType();
			if(mpServer.containsKey(serverType)){
				mpServer.get(serverType).add(servers[i]);
			}
			else{
				List<IServer> svrs = new ArrayList<IServer>();
				svrs.add(servers[i]);
				mpServer.put(serverType, svrs);
			}
		}
		return mpServer;
	}
	
	public static IVersion getSTPVersionFromWTPServer(String serverId){
		if(serverId == null){
			return null;
		}
		String version = null;
		int maj = 0;
		int minor = 0;
		int index = serverId.lastIndexOf(".");
		if(index > 0){
			version = serverId.substring(index + 1);
			if(version.length()>1){
				minor = Integer.valueOf(version.substring(version.length() - 1));
				maj = Integer.valueOf(version.substring(0, version.length() - 1));
			}
		}
		return new Version(maj, minor, 0, "");
		
	}
	


	public static IVersion getSTPVersionByWTPRuntimeType(IRuntimeType runtimeType) {

		String wtpVersion = runtimeType.getVersion();

		int maj = 0;
		int min = 0;
		try {
			if (wtpVersion.length() > 1 && wtpVersion.indexOf(".") >= 0) {
				min = Integer.valueOf(wtpVersion
						.substring(wtpVersion.indexOf(".") + 1));
				maj = Integer.valueOf(wtpVersion
						.substring(0, wtpVersion.indexOf(".")));
			} 
			else if (Integer.valueOf(wtpVersion) != null) {
				return new Version(Integer.valueOf(wtpVersion), min, 0, "");
			}
		} catch (Exception ex) {
			return Version.NULL_VERSION;
		}

		return new Version(maj, min, 0, "");

	}
	
	public static IVersion getSTPVersionByWTPServerType(IServerType serverType) {
		return getSTPVersionByWTPRuntimeType(serverType.getRuntimeType());

	}

	public static IVersion getSTPVersionFromWTPServer(IServer server) {

		return getSTPVersionByWTPServerType(server.getServerType());

	}
	
	public static org.eclipse.stp.soas.deploy.core.IServerType convertWTPServerTypeToSTPServerType(IServerType wtpServerType){
		
		String serverTypeId = wtpServerType.getId();
		return getServerTypeByServerTypeId(serverTypeId);
		
	}
	
	public static org.eclipse.stp.soas.deploy.core.IServerType getServerTypeByServerTypeId(String  wtpServerTypeId){
		 
		IServerType serverType = ServerCore.findServerType(wtpServerTypeId);
		IVersion version = getSTPVersionByWTPServerType(serverType);
		return new org.eclipse.stp.soas.deploy.core.ServerType(wtpServerTypeId, version);
	}
	
	public static void deployWTPModule(IPackageOutputDescriptor descriptor, String serverID, IProject project) throws Exception {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IProject[] projects = root.getProjects();
		WTPServiceModuleFactory moduleFactory = null;
		
		for (ModuleFactory mf : ServerPlugin.getModuleFactories()) {
			if (mf.getId().equals("org.eclipse.stp.soas.deploy.core.serverModuleFactory")) {
				moduleFactory = (WTPServiceModuleFactory)mf.getDelegate(null);
				LOG.debug("found stp module factory");
				break;
			}
		}
		
		IModule module = moduleFactory.createModule(project, descriptor);
		
		if (module != null) {
			LOG.debug("created IModule:" + module + " for server:" + serverID);
			
			IServer server = ServerCore.findServer(serverID);
			if (server != null) {
		        IServerWorkingCopy workingCopy = server.createWorkingCopy();
				workingCopy.modifyModules(new IModule[] {module}, 
				    null,
					null);
				IServer updatedSvr = workingCopy.save(false, null);
				LOG.debug("added to the server");
				for (IModule mod : updatedSvr.getModules()) {
						LOG.debug("server mod:" + mod.getName());
				} 
			}
		}

	}
	
	public static void undeployWTPModule(IPackageOutputDescriptor descriptor, String serverID) throws Exception {
		WTPServiceModuleFactory moduleFactory = null;

		for (ModuleFactory mf : ServerPlugin.getModuleFactories()) {
			if (mf.getId().equals(
					"org.eclipse.stp.soas.deploy.core.serverModuleFactory")) {
				moduleFactory = (WTPServiceModuleFactory) mf.getDelegate(null);
				LOG.debug("found stp module factory");
				break;
			}
		}

		String moduleName = moduleFactory.getModuleName(descriptor);
		IServer server = ServerCore.findServer(serverID);
		IModule module = null;
		if (server != null) {
			
			for (IModule mod : server.getModules()) {
				if(mod.getName().equals(moduleName)){
					module = mod;
					break;
				}					
				LOG.debug("server mod:" + mod.getName());
			}
			if (module != null) {
				IServerWorkingCopy workingCopy = server.createWorkingCopy();
				workingCopy.modifyModules(null, new IModule[] { module }, null);
				IServer updatedSvr = workingCopy.save(false, null);
				LOG.debug("remove from the server");
			} 
		} 

	}
	
	public static boolean containsWTPModule(
			IPackageOutputDescriptor descriptor, String serverID) {
		 
		WTPServiceModuleFactory moduleFactory = null;

		for (ModuleFactory mf : ServerPlugin.getModuleFactories()) {
			if (mf.getId().equals(
					"org.eclipse.stp.soas.deploy.core.serverModuleFactory")) {
				moduleFactory = (WTPServiceModuleFactory) mf.getDelegate(null);
				LOG.debug("found stp module factory");
				break;
			}
		}

		String moduleName = moduleFactory.getModuleName(descriptor);
		IServer server = ServerCore.findServer(serverID);
		if (server != null) {
			
			for (IModule mod : server.getModules()) {
				if(mod.getName().equals(moduleName)){
					return true;
				}					
				LOG.debug("server mod:" + mod.getName());
			}

		}

		return false;
	}
	 
}
