/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.rule.model;

import org.w3c.dom.Document;

/**
 * @author jma
 *
 */
public abstract class VRule {
	
	VRuleDef ruleDef;
	
	public VRule() {
		this(null);
	}
	
	public VRule(VRuleDef def) {
		ruleDef = def;
	}
	
	public VRuleDef getRuleDef() {
		return ruleDef;
	}
	
	public void setVRuleDef(VRuleDef def) {
		ruleDef = def;
	}
	
	
	/**
	 * generate validate method in memory according to rule definition
	 * using the ClassBuilder
	 * @return
	 * @see org.eclipse.stp.sc.xmlvalidator.rule.builder.RuleClassBuilder
	 */
	public abstract boolean validate(Document doc);
	
	

}
