/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jpt.db.internal.Catalog;
import org.eclipse.jpt.db.internal.Column;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.NullDatabase;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Database
extends DTPWrapper
implements Comparable<Database> {
    private boolean caseSensitive = false;

    static Database createDatabase(ConnectionProfile profile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        return dtpDatabase == null ? NullDatabase.instance() : new DTPDatabaseWrapper(profile, dtpDatabase);
    }

    Database() {
    }

    abstract void catalogChanged(Catalog var1, int var2);

    abstract void schemaChanged(Schema var1, int var2);

    abstract void tableChanged(Table var1, Schema var2, int var3);

    abstract void refresh();

    protected Schema wrap(org.eclipse.datatools.modelbase.sql.schema.Schema schema) {
        return new Schema(this, schema);
    }

    protected Catalog wrap(org.eclipse.datatools.modelbase.sql.schema.Catalog catalog) {
        return new Catalog(this, catalog);
    }

    public abstract String getVendor();

    public abstract String getVersion();

    Column column(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        return this.table(dtpColumn.getTable()).column(dtpColumn);
    }

    Table table(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        return this.schema(dtpTable.getSchema()).table(dtpTable);
    }

    @Override
    public int compareTo(Database database) {
        return Collator.getInstance().compare(this.getName(), database.getName());
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    abstract Set<Catalog> getCatalogs();

    public abstract boolean supportsCatalogs();

    public abstract String getDefaultCatalogName();

    public Iterator<Catalog> catalogs() {
        return this.getCatalogs().iterator();
    }

    public int catalogSize() {
        return this.getCatalogs().size();
    }

    public Iterator<String> catalogNames() {
        return new TransformationIterator<Catalog, String>(this.catalogs()){

            protected String transform(Catalog catalog) {
                return catalog.getName();
            }
        };
    }

    public boolean containsCatalogNamed(String name) {
        return this.catalogNamed(name) != null;
    }

    public Catalog catalogNamed(String name) {
        return this.isCaseSensitive() ? this.catalogNamedInternal(name) : this.catalogNamedIgnoreCase(name);
    }

    private Catalog catalogNamedInternal(String name) {
        Iterator<Catalog> stream = this.catalogs();
        while (stream.hasNext()) {
            Catalog catalog = stream.next();
            if (!catalog.getName().equals(name)) continue;
            return catalog;
        }
        return null;
    }

    private Catalog catalogNamedIgnoreCase(String name) {
        Iterator<Catalog> stream = this.catalogs();
        while (stream.hasNext()) {
            Catalog catalog = stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)catalog.getName(), (String)name)) continue;
            return catalog;
        }
        return null;
    }

    Catalog catalog(org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        Iterator<Catalog> stream = this.catalogs();
        while (stream.hasNext()) {
            Catalog catalog = stream.next();
            if (!catalog.wraps(dtpCatalog)) continue;
            return catalog;
        }
        throw new IllegalArgumentException("invalid dtp catalog: " + dtpCatalog);
    }

    abstract Set<Schema> getSchemata();

    public Iterator<Schema> schemata() {
        return this.getSchemata().iterator();
    }

    public int schemataSize() {
        return this.getSchemata().size();
    }

    public boolean schemataContains(Column column) {
        return this.getSchemata().contains(column);
    }

    public Iterator<String> schemaNames() {
        return new TransformationIterator<Schema, String>(this.schemata()){

            protected String transform(Schema schema) {
                return schema.getName();
            }
        };
    }

    public boolean containsSchemaNamed(String name) {
        return this.schemaNamed(name) != null;
    }

    public Schema schemaNamed(String name) {
        return this.isCaseSensitive() ? this.schemaNamedInternal(name) : this.schemaNamedIgnoreCase(name);
    }

    private Schema schemaNamedInternal(String name) {
        Iterator<Schema> stream = this.schemata();
        while (stream.hasNext()) {
            Schema schema = stream.next();
            if (!schema.getName().equals(name)) continue;
            return schema;
        }
        return null;
    }

    private Schema schemaNamedIgnoreCase(String name) {
        Iterator<Schema> stream = this.schemata();
        while (stream.hasNext()) {
            Schema schema = stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)schema.getName(), (String)name)) continue;
            return schema;
        }
        return null;
    }

    Schema schema(org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        Iterator<Schema> stream = this.schemata();
        while (stream.hasNext()) {
            Schema schema = stream.next();
            if (!schema.wraps(dtpSchema)) continue;
            return schema;
        }
        throw new IllegalArgumentException("invalid dtp schema: " + dtpSchema);
    }
}

