/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.impl.jdbc.Util;

public class EXTDTAInputStream
extends InputStream {
    long dataLength = 0L;
    InputStream binaryInputStream = null;
    int columnNumber;
    ResultSet dataResultSet = null;

    private EXTDTAInputStream(int n, InputStream inputStream) {
        this.dataLength = n;
        this.binaryInputStream = inputStream;
    }

    public static EXTDTAInputStream getEXTDTAStream(ResultSet resultSet, int n, int n2) throws SQLException {
        Object object;
        EXTDTAInputStream eXTDTAInputStream = null;
        int n3 = 0;
        byte[] byArray = null;
        int n4 = n2 | 1;
        if (n4 == 201) {
            byArray = resultSet.getBytes(n);
        } else if (n4 == 207) {
            object = resultSet.getString(n);
            try {
                if (object != null) {
                    byArray = ((String)object).getBytes("UTF8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        if (byArray != null) {
            n3 = byArray.length;
            object = new ByteArrayInputStream(byArray);
            eXTDTAInputStream = new EXTDTAInputStream(n3, (InputStream)object);
        }
        return eXTDTAInputStream;
    }

    private static long getInputStreamLength(InputStream inputStream) throws SQLException {
        long l = 0L;
        if (inputStream == null) {
            return l;
        }
        try {
            while (true) {
                int n = inputStream.available();
                inputStream.skip(n);
                if (n != 0) {
                    l += (long)n;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Util.javaException(iOException);
        }
        return l;
    }

    public long length() throws SQLException {
        return this.dataLength;
    }

    public int read() throws IOException {
        return this.binaryInputStream.read();
    }

    public int available() throws IOException {
        return this.binaryInputStream.available();
    }

    public void close() throws IOException {
        if (this.binaryInputStream != null) {
            this.binaryInputStream.close();
        }
    }

    public boolean equals(Object object) {
        return this.binaryInputStream.equals(object);
    }

    public int hashCode() {
        return this.binaryInputStream.hashCode();
    }

    public void mark(int n) {
        this.binaryInputStream.mark(n);
    }

    public boolean markSupported() {
        return this.binaryInputStream.markSupported();
    }

    public int read(byte[] byArray) throws IOException {
        return this.binaryInputStream.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.binaryInputStream.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        this.binaryInputStream.reset();
    }

    public long skip(long l) throws IOException {
        return this.binaryInputStream.skip(l);
    }
}

