/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateAliasConstantAction
extends DDLConstantAction {
    private final String aliasName;
    private final String schemaName;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final AliasInfo aliasInfo;

    CreateAliasConstantAction(String string, String string2, String string3, AliasInfo aliasInfo, char c) {
        this.aliasName = string;
        this.schemaName = string2;
        this.javaClassName = string3;
        this.aliasInfo = aliasInfo;
        this.aliasType = c;
        switch (c) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            default: {
                this.nameSpace = '\u0000';
            }
        }
    }

    public String toString() {
        String string = null;
        switch (this.aliasType) {
            case 'P': {
                string = "CREATE PROCEDURE ";
                break;
            }
            case 'F': {
                string = "CREATE FUNCTION ";
                break;
            }
            case 'S': {
                string = "CREATE SYNONYM ";
                break;
            }
        }
        return string + this.aliasName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        Serializable serializable;
        Object object2;
        LanguageConnectionContext languageConnectionContext = activation != null ? activation.getLanguageConnectionContext() : (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        String string = null;
        String string2 = this.javaClassName;
        if (this.aliasInfo != null) {
            string = this.aliasInfo.getMethodName();
        }
        switch (this.aliasType) {
            case 'F': 
            case 'P': 
            case 'S': {
                break;
            }
            default: {
                int n;
                object2 = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
                serializable = null;
                try {
                    serializable = object2.loadApplicationClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw StandardException.newException("42X51", classNotFoundException, (Object)string2);
                }
                if (!Modifier.isPublic(((Class)serializable).getModifiers())) {
                    throw StandardException.newException("42X51", string2);
                }
                if (string == null) break;
                object = ((Class)serializable).getMethods();
                for (n = 0; !(n >= ((Method[])object).length || Modifier.isStatic(object[n].getModifiers()) && string.equals(object[n].getName())); ++n) {
                }
                if (n != ((Method[])object).length) break;
                throw StandardException.newException("42Y16", string, (Object)string2);
            }
        }
        dataDictionary.startWriting(languageConnectionContext);
        object2 = null;
        if (activation == null) {
            object2 = dataDictionary.getSysIBMSchemaDescriptor();
        } else if (this.schemaName != null) {
            object2 = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        }
        serializable = dataDictionary.getUUIDFactory().createUUID();
        object = new AliasDescriptor(dataDictionary, (UUID)serializable, this.aliasName, object2 != null ? ((SchemaDescriptor)object2).getUUID() : null, this.javaClassName, this.aliasType, this.nameSpace, false, this.aliasInfo, null);
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                List list = dataDictionary.getRoutineList(((SchemaDescriptor)object2).getUUID().toString(), this.aliasName, this.aliasType);
                for (int i = list.size() - 1; i >= 0; --i) {
                    AliasDescriptor aliasDescriptor = (AliasDescriptor)list.get(i);
                    RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                    int n = routineAliasInfo.getParameterCount();
                    if (n != ((RoutineAliasInfo)this.aliasInfo).getParameterCount()) continue;
                    throw StandardException.newException("X0Y68.S", ((AliasDescriptor)object).getDescriptorType(), (Object)this.aliasName);
                }
                break;
            }
            case 'S': {
                Object object3;
                TupleDescriptor tupleDescriptor;
                SchemaDescriptor schemaDescriptor;
                TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.aliasName, (SchemaDescriptor)object2);
                if (tableDescriptor != null) {
                    throw StandardException.newException("X0Y68.S", tableDescriptor.getDescriptorType(), (Object)tableDescriptor.getDescriptorName());
                }
                String string3 = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
                String string4 = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
                while ((schemaDescriptor = dataDictionary.getSchemaDescriptor(string4, transactionController, false)) != null && (tupleDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string3, this.nameSpace)) != null) {
                    object3 = (SynonymAliasInfo)tupleDescriptor.getAliasInfo();
                    string3 = ((SynonymAliasInfo)object3).getSynonymTable();
                    string4 = ((SynonymAliasInfo)object3).getSynonymSchema();
                    if (!this.aliasName.equals(string3) || !this.schemaName.equals(string4)) continue;
                    throw StandardException.newException("42916", this.aliasName, (Object)((SynonymAliasInfo)this.aliasInfo).getSynonymTable());
                }
                if (schemaDescriptor != null) {
                    tableDescriptor = dataDictionary.getTableDescriptor(string3, schemaDescriptor);
                }
                if (schemaDescriptor == null || tableDescriptor == null) {
                    activation.addWarning(StandardException.newWarning("01522", this.aliasName, string4 + "." + string3));
                }
                object3 = dataDictionary.getDataDescriptorGenerator();
                tupleDescriptor = ((DataDescriptorGenerator)object3).newTableDescriptor(this.aliasName, (SchemaDescriptor)object2, 4, 'R');
                dataDictionary.addDescriptor(tupleDescriptor, (TupleDescriptor)object2, 1, false, transactionController);
            }
        }
        dataDictionary.addDescriptor((TupleDescriptor)object, null, 7, false, languageConnectionContext.getTransactionExecute());
    }
}

