/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.data;

import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DimensionMessages;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.data.Unit;
import org.eclipse.test.performance.Dimension;

public class Dim
implements Dimension {
    private static Dim[] fgRegisteredDimensions = new Dim[100];
    private final int fId;
    private final Unit fUnit;
    private final int fMultiplier;
    private final boolean fLargerIsBetter = false;

    public static Dim getDimension(int id) {
        InternalDimensions.COMITTED.getId();
        if (id >= 0 && id < fgRegisteredDimensions.length) {
            return fgRegisteredDimensions[id];
        }
        return null;
    }

    public Dim(int id) {
        this(id, Unit.CARDINAL, 1);
    }

    public Dim(int id, Unit unit) {
        this(id, unit, 1);
    }

    public Dim(int id, Unit unit, int multiplier) {
        if (id >= 0 && id < fgRegisteredDimensions.length) {
            if (fgRegisteredDimensions[id] == null) {
                Dim.fgRegisteredDimensions[id] = this;
            } else {
                PerformanceTestPlugin.logError("dimension with id '" + id + "' already registered");
            }
        }
        this.fId = id;
        this.fUnit = unit;
        this.fMultiplier = multiplier;
    }

    public int getId() {
        return this.fId;
    }

    public Unit getUnit() {
        return this.fUnit;
    }

    public int getMultiplier() {
        return this.fMultiplier;
    }

    public boolean largerIsBetter() {
        return false;
    }

    public String getName() {
        return DimensionMessages.getString(this.fId);
    }

    public String toString() {
        return "Dimension [name=" + this.getName() + ", " + this.fUnit + "]";
    }

    public String getDisplayValue(Scalar scalar) {
        return this.fUnit.getDisplayValue1(scalar.getMagnitude(), this.fMultiplier);
    }

    public String getDisplayValue(double scalar) {
        return this.fUnit.getDisplayValue1(scalar / (double)this.fMultiplier);
    }
}

